



<html>
<head>
  <title>javabog.dk -  - Basal programmering</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel1.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel3.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">2 <a name='afsn2'></a>Basal
programmering</H1>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI VALUE=1><P LANG="da-DK" CLASS="kapiteloversigt-western">Variabler,
  tildelinger og regneudtryk</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Forgreninger og
  l&oslash;kker</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Kald af metoder</P>
</UL>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Kapitlet foruds&aelig;ttes
i resten af bogen.</P>


<H2 CLASS="western" STYLE="">2.1 <a name='afsn2.1'></a>Det f&oslash;rste
javaprogram</SPAN></H2>
<P LANG="da-DK" CLASS="western">Lad os se p&aring; et simpelt
javaprogram, der skriver &quot;Hej verden&quot; og et citat af Storm
P. ud til sk&aelig;rmen. Neden under den vandrette linje er vist,
hvad der sker, hvis programmet k&oslash;res:</P>
<PRE CLASS="kode-western"><I>// Et simpelt program, der skriver &quot;Hej verden&quot; </I>
<I>// og et citat af Storm P. ud til sk&aelig;rmen</I>
<I>// Denne fil skal have navnet: HejVerden.java</I>
public class HejVerden
{
  public static void main (String[] arg)
  {
    System.out.println(&quot;Hej Verden!&quot;);
    System.out.println(&quot;Hvorn&aring;r smager en Tuborg bedst?&quot;);
    System.out.println(&quot;Hvergang!&quot;);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Hej Verden!
Hvorn&aring;r smager en Tuborg bedst?
Hvergang!</PRE><P LANG="da-DK" CLASS="western">
Alle javaprogrammer har den samme grundl&aelig;ggende struktur, som
ogs&aring; kan ses af dette eksempel.</P>
<H3 CLASS="western">2.1.1 <a name='afsn2.1.1'></a>Kommentarer</H3>
<P LANG="da-DK" CLASS="western">Kommentarer er dokumentation beregnet
p&aring;, at g&oslash;re programmets kildetekst lettere at forst&aring;
for l&aelig;seren. De p&aring;virker ikke programudf&oslash;relsen. 
</P>
<P LANG="da-DK" CLASS="western">De f&oslash;rste 3 linjer, der
starter med //, er kommentarer:</P>
<PRE CLASS="ikke-javakode-western"><I>// Et simpelt program, der skriver &quot;Hej verden&quot; </I>
<I>// og et citat af Storm P. ud til sk&aelig;rmen</I>
<I>// Denne fil skal have navnet: HejVerden.java</I></PRE><P LANG="da-DK" CLASS="western">
I dette tilf&aelig;lde er der beskrevet, hvad programmet g&oslash;r
og hvilket filnavn kildeteksten b&oslash;r gemmes i.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Kommentarer
bliver sprunget over og har ingen indflydelse p&aring; programmet</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Kommentarer b&oslash;r
skrives, s&aring; de giver forst&aring;else for, hvordan programmet
virker&nbsp;-&nbsp;uden at v&aelig;re tvetydige eller forklare
indlysende ting</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">// markerer, at resten af linjen er
en kommentar. Den kan ogs&aring; bruges efter en kommando til at
forklare, hvad der sker, f.eks.</P>
<PRE CLASS="kode-western">    System.out.println(&quot;Hej verden!&quot;);  <I>// Udskriv en hilsen</I></PRE><P LANG="da-DK" CLASS="western">
Java har ogs&aring; en anden form, som kan v&aelig;re nyttig til
kommentarer over flere linjer: Man kan starte en kommentar med /* og
afslutte den med */. Al tekst mellem /* og */ bliver s&aring;
opfattet som kommentarer. Vi kunne alts&aring; ogs&aring; skrive</P>
<PRE CLASS="ikke-javakode-western"><I><B>/*</B></I>
<I>// Et simpelt program, der skriver &quot;Hej verden&quot; </I>
<I>// og et citat af Storm P. ud til sk&aelig;rmen</I>
<I>// Denne fil skal have navnet: HejVerden.java</I>
<I>*/</I></PRE><P LANG="da-DK" CLASS="western">
og</P>
<PRE CLASS="kode-western">    System.out.println(&quot;Hej verden!&quot;);  <I><B>/*</B></I><I> Udskriv en hilsen </I><I><B>*/</B></I></PRE><P LANG="da-DK" CLASS="western">
I denne bog skriver vi kommentarer i <I>kursiv</I> for at lette
l&aelig;sningen af eksemplerne.</P>
<H3 CLASS="western" STYLE="">2.1.2 <a name='afsn2.1.2'></a>Klassedefinitionen</H3>
<P LANG="da-DK" CLASS="western">Resten af teksten kaldes en
klassedefinition og beskriver selve programmet (HejVerden). 
</P>
<P LANG="da-DK" CLASS="western">Den best&aring;r af en fast struktur:</P>
<PRE CLASS="ikke-javakode-western">public class HejVerden
{
  public static void main (String[] arg)
  {
    ...
  }
}</PRE><P LANG="da-DK" CLASS="western">
og noget programkode - kommandoer, der skal udf&oslash;res, n&aelig;rmest
som en bageopskrift: 
</P>
<PRE CLASS="kode-western">    System.out.println(&quot;Hej verden!&quot;);</PRE><H4 CLASS="western">
Strukturdelen</H4>
<P LANG="da-DK" CLASS="western">Strukturdelen vil ikke blive &aelig;ndret
i de n&aelig;ste to kapitler og det er ikke s&aring; vigtigt, at du
forst&aring;r, hvad der foreg&aring;r i f&oslash;rste omgang. 
</P>
<P LANG="da-DK" CLASS="western">Al javakode er indkapslet i en klasse
mellem { og } (blokstart og blokslut-parenteser). Beskrivelsen af en
klasse er altid indkapslet i en blok best&aring;ende af:</P>
<PRE CLASS="ikke-javakode-western">public class HejVerden
{
  ...
}</PRE><P LANG="da-DK" CLASS="western">
Inde i klassen st&aring;r der en main-metode med nogle kommandoer i. 
</P>
<PRE CLASS="kode-western">  public static void main (String[] arg)
  {
    ...
  }</PRE><P LANG="da-DK" CLASS="western">
Indholdet af metoden er altid indkapslet i en blok med { og }.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Programudf&oslash;relsen
starter i metoden:<BR>  <FONT FACE="Courier, monospace">public static
void main (String[] arg)</FONT></BLOCKQUOTE>
<H4 CLASS="western">Programkode</H4>
<P LANG="da-DK" CLASS="western">I main-metoden giver man
instruktioner til computeren:</P>
<PRE CLASS="kode-western">    System.out.println(&quot;Hej verden!&quot;);
    System.out.println(&quot;Hvorn&aring;r smager en Tuborg bedst?&quot;);
    System.out.println(&quot;Hvergang!&quot;);</PRE><P LANG="da-DK" CLASS="western">
Instruktionerne udf&oslash;res altid en efter en, ovenfra og ned.
Hver instruktion afsluttes med et semikolon.</P>
<P LANG="da-DK" CLASS="western">Disse 3 instruktioner skriver 3
strenge (&quot;Hej verden!&quot;, ...) ud til sk&aelig;rmen. En
streng er en tekst, som computeren kan arbejde med. Strenge er altid
indkapslet i &quot;&quot;.</P>
<P LANG="da-DK" CLASS="western">Hver instruktion best&aring;r af et
kald til metoden System.out.println, som betyder, at der skal
udskrives noget til sk&aelig;rmen og en streng som parameter. 
</P>
<P LANG="da-DK" CLASS="western">En parameter er en oplysning, som man
overf&oslash;rer til metoden. I dette tilf&aelig;lde hvilken tekst,
der skal skrives ud til sk&aelig;rmen.</P>
<P LANG="da-DK" CLASS="western">Vores main-metode kalder alts&aring;
andre metoder.</P>
<H3 CLASS="western">2.1.3 <a name='afsn2.1.3'></a>Overs&aelig;ttelse og k&oslash;rsel af
programmet</H3>
<P LANG="da-DK" CLASS="western">N&aring;r man skal udvikle et
program, skriver man f&oslash;rst en kildetekst (eng.: source code),
der beskriver, hvad det er, man vil have programmet til at g&oslash;re.
Programmet, vi lige har set, er et eksempel p&aring; en
kildetekstfil.</P>

<P LANG="da-DK" CLASS="western" STYLE="">Instruktionerne,
som centralenheden i computeren arbejder med, er i en bin&aelig;r
kode (kaldet maskinkode eller bytekode), der er umulig at l&aelig;se
for almindelige mennesker. 
</P>
<P LANG="da-DK" CLASS="western">Kildeteksten skal derfor overs&aelig;ttes
(eng.: compile; mange siger ogs&aring; kompilere p&aring; dansk) til
den bin&aelig;re kode, som s&aring; kan udf&oslash;res af computeren.</P>
<P LANG="da-DK" CLASS="western">I Java kalder man den bin&aelig;re
kode for bytekode. Bytekode er platformuafh&aelig;ngigt, dvs. at det
kan k&oslash;re p&aring; stort set alle hardware-platforme og alle
styresystemer. De fleste andre sprogs bin&aelig;re kode er ikke
indrettet til at v&aelig;re platformuafh&aelig;ngigt.</P>
<P LANG="da-DK" CLASS="western">For at overs&aelig;tte programmet
HejVerden skal det gemmes i en fil med navnet &quot;HejVerden.java&quot;.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">En kildetekstfil
skal hedde det samme som klassen og skal have .java som filendelse</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Eksempel: Klassen hedder HejVerden og
filen hedder HejVerden.java.</P>
<H4 CLASS="western">Overs&aelig;ttelse og k&oslash;rsel fra
kommandolinjen</H4>
<P LANG="da-DK" CLASS="western">Hvis du bruger det
kommandolinje-orienterede JDK direkte, skal du &aring;bne en
DOS/UNIX-kommandoprompt<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>
og st&aring; i den samme mappe som kildeteksten findes<A CLASS="sdfootnoteanc" NAME="sdfootnote2anc" HREF="#sdfootnote2sym"><SUP>2</SUP></A>.
Skriv s&aring;<A CLASS="sdfootnoteanc" NAME="sdfootnote3anc" HREF="#sdfootnote3sym"><SUP>3</SUP></A>:</P>
<PRE CLASS="western">  javac HejVerden.java</PRE><P LANG="da-DK" CLASS="western">
Dette overs&aelig;tter programmet til bytekode (filen HejVerden.class
skulle nu gerne ligge i samme mappe). Nu kan du k&oslash;re
programmet med kommandoen<A CLASS="sdfootnoteanc" NAME="sdfootnote4anc" HREF="#sdfootnote4sym"><SUP>4</SUP></A>:</P>
<PRE CLASS="western">  java HejVerden</PRE><P LANG="da-DK" CLASS="western">
Resultatet udskrives i vinduet:</P>
<PRE CLASS="kode-western">Hej Verden!
Hvorn&aring;r smager en Tuborg bedst?
Hvergang!</PRE>
<P LANG="da-DK" CLASS="western" ALIGN=CENTER><IMG SRC="bog3_html_497421c2.gif" NAME="Objekt6" ALIGN=MIDDLE></P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>Overs&aelig;ttelse og
udf&oslash;relse af programmet HejVerden</I></FONT></P>

<H4 CLASS="western" STYLE="">Overs&aelig;ttelse
og k&oslash;rsel med et udviklingsv&aelig;rkt&oslash;j</H4>
<P LANG="da-DK" CLASS="western">I de fleste udviklingsv&aelig;rkt&oslash;jer
skal du oprette et <I>projekt</I><SPAN STYLE="font-style: normal">
(f.eks. i JBuilder: File/New Pro</SPAN>ject). F&oslash;j
derefter din java-fil til projektet. Husk at placere filen i den
mappe, som projektet angiver (eller rette projektets egenskaber).</P>
<P LANG="da-DK" CLASS="western"><SPAN STYLE="font-style: normal">N&aring;r
man vil overs&aelig;tte sit java-program, skal man v&aelig;lge </SPAN><I>make</I><SPAN STYLE="font-style: normal">
(det er et engelsk ord). N&aring;r man har gjort det, kan man k&oslash;re
sit program med </SPAN><I>run</I><SPAN STYLE="font-style: normal">.</SPAN></P>
<H2 CLASS="western">2.2 <a name='afsn2.2'></a>Variabler</SPAN></H2>
<P LANG="da-DK" CLASS="western">Variabler bruges til at opbevare og
&aelig;ndre data. En variabel kan opfattes som en navngiven
papirlap, hvor der til enhver tid kan st&aring; netop &eacute;n ting.</P>
<P LANG="da-DK" CLASS="western">Variabler skal altid erkl&aelig;res,
dvs. at man skal fort&aelig;lle computeren, at der skal oprettes en
variabel, hvad slags data den skal indeholde og hvad den skal hedde. 
</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">En variabel er et
navn p&aring; et sted i computerens hukommelse, beregnet p&aring; at
indeholde data af en bestemt type</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">En variabel
erkl&aelig;res ved at skrive <I>variabeltype</I> <I>variabelnavn;</I></BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Det er en god vane, at give
variablerne sigende navne. Navnene b&oslash;r starte med et lille
bogstav.</P>
<P LANG="da-DK" CLASS="western">I det f&oslash;lgende gennemg&aring;r
vi to af Javas variabeltyper: int (heltal) og double (kommatal).</P>
<H3 CLASS="western">2.2.1 <a name='afsn2.2.1'></a>Heltal</H3>
<P LANG="da-DK" CLASS="western">En variabel af type<SPAN ID="Ramme7" DIR="LTR" STYLE="float: right; width: 1.43cm; height: 1.88cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog3_html_675ff1a.gif" NAME="Objekt22" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>Efter
  1. tildeling</I></FONT></P>
</SPAN>n int (et heltal, eng.: integer) erkl&aelig;res med
</P>
<PRE CLASS="kode-western">    int tal;</PRE><P LANG="da-DK" CLASS="western">
Nu er der reserveret plads i hukommelsen til et heltal<A CLASS="sdfootnoteanc" NAME="sdfootnote5anc" HREF="#sdfootnote5sym"><SUP>5</SUP></A>.
Man f&aring;r fat i pladsen, ved at bruge variabelnavnet <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">tal</SPAN></SPAN></FONT></FONT>.
Efter at variablen er erkl&aelig;ret, kan den tildeles en v&aelig;rdi,
dvs. man kan skrive data ind i den:</P>
<PRE CLASS="kode-western">    tal = 22;</PRE><P LANG="da-DK" CLASS="western">
Nu er v&aelig;rdien af <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">tal</SPAN></SPAN></FONT></FONT>
22 (vist p&aring; figuren til h&oslash;jre). 
</P>
<P LANG="da-DK" CLASS="western">Vi kan bruge tal-variablen i stedet
for at skrive 22, f.eks. til at skrive ud til sk&aelig;rmen:</P>
<PRE CLASS="kode-western">    System.out.println(&quot;Svaret p&aring; livet, universet og alt det der: &quot; + tal);</PRE><P LANG="da-DK" CLASS="western">
Her sl&aring;r computeren op i hukommelsen, l&aelig;ser indholdet af
tal-variablen og skriver det ud til sk&aelig;rmen (+'et vil blive
forklaret i n&aelig;ste afsnit).</P>
<P LANG="da-DK" CLASS="western"><SPAN ID="Ramme10" DIR="LTR" STYLE="float: right; width: 1.43cm; height: 1.88cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog3_html_m490162dd.gif" NAME="Objekt40" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>Efter
  2. tildeling</I></FONT></P>
</SPAN>Variabler kan, som navnet siger, &aelig;ndre v&aelig;rdi. Det
g&oslash;r vi, ved at tildele variablen en ny v&aelig;rdi:
</P>
<PRE CLASS="kode-western">    tal = 42;</PRE><P LANG="da-DK" CLASS="western">
Herefter er den gamle v&aelig;rdi fuldst&aelig;ndigt glemt og
erstattet med den nye. N&aring;r programudf&oslash;relsen n&aring;r
et punkt, hvor variablen l&aelig;ses, vil det v&aelig;re den nye
v&aelig;rdi, 42, der g&aelig;lder.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">I en tildeling
l&aelig;ses v&aelig;rdien p&aring; h&oslash;jre side og gemmes i
variablen p&aring; venstre side</BLOCKQUOTE>

<P LANG="da-DK" CLASS="western" STYLE="">Herunder
er eksemplet i sin helhed (den v&aelig;sentlige del af koden er
fremh&aelig;vet med fed):</P>
<PRE CLASS="kode-western"><I>// Eksempel p&aring; brug af en variabel</I>
<I>// koden skal v&aelig;re i filen Variabler.java</I>
public class Variabler
{
  public static void main (String[] arg)
  {
<B>    int tal;</B>
<B>    tal = 22;</B>
<B>    System.out.println(&quot;Svaret p&aring; livet, universet og alt det der: &quot; + tal);</B>

<B>    tal = 42;</B>
<B>    System.out.println(&quot;Undskyld, svaret er: &quot; + tal);</B>
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Svaret p&aring; livet, universet og alt det der: 22
Undskyld, svaret er: 42</PRE><H3 CLASS="western">
2.2.2 <a name='afsn2.2.2'></a>Sammens&aelig;tte strenge med +</H3>
<P LANG="da-DK" CLASS="western">Som det er vist i ovenst&aring;ende
eksempel, kan vi med tegnet <B>+,</B> s&aelig;tte strenge sammen med
noget andet:</P>
<PRE CLASS="kode-western">    System.out.println(<B>&quot;Svaret p&aring; livet, universet og alt det der: &quot; + tal</B>);</PRE><P LANG="da-DK" CLASS="western">
Herunder s&aelig;tter vi to strenge sammen:</P>
<PRE CLASS="kode-western"><I>// Sammens&aelig;t to strenge med +</I>
<I>// koden skal v&aelig;re i filen HejVerden2.java</I>
public class HejVerden2
{
  public static void main (String[] arg)
  {
    System.out.println(<B>&quot;Hej &quot; + &quot;Verden!&quot;</B>);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Hej Verden!</PRE><P LANG="da-DK" CLASS="western">
Herunder skriver vi en streng og tallet 42 ud:</P>
<PRE CLASS="kode-western">public class HejVerden3
{
  public static void main (String[] arg)
  {
    System.out.println(&quot;Svaret p&aring; livet, universet og alt det der: &quot;<B> + 42</B>);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Svaret p&aring; livet, universet og alt det der: 42</PRE><P LANG="da-DK" CLASS="western">
Det der egentlig sker er, at det hele bliver sat sammen til &eacute;n
streng og den sendes til System.out.println(). 
</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">En streng + noget
andet s&aelig;ttes sammen til en samlet streng</BLOCKQUOTE>
<H3 CLASS="western">2.2.3 <a name='afsn2.2.3'></a>Beregningsudtryk</H3>
<P LANG="da-DK" CLASS="western">Man kan erkl&aelig;re flere variabler
p&aring; samme linje:</P>
<PRE CLASS="kode-western">    int antalHunde, antalKatte, antalDyr;
    antalHunde = 5;
    antalKatte = 8; </PRE><P LANG="da-DK" CLASS="western">
Tildelinger kan indeholde regneudtryk p&aring; h&oslash;jre side af
lighedstegnet. Udtrykket antalHunde + antalKatte udregnes og
resultatet l&aelig;gges i variablen p&aring; venstre side (det er
ikke tilladt at have beregningsudtryk p&aring; venstre side):</P>
<PRE CLASS="kode-western">    antalDyr = antalHunde + antalKatte;</PRE>
<P LANG="da-DK" CLASS="western" STYLE="">Beregningsudtrykkene
unders&oslash;ges af Java ved at inds&aelig;tte v&aelig;rdien af
variablerne. Her inds&aelig;tter Java 5 + 8 og f&aring;r 13, som
l&aelig;gges i <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">antalDyr</SPAN></SPAN></FONT></FONT>.</P>
<PRE CLASS="kode-western">public class Dyreinternat
{
  public static void main(String[] arg) 
  {
    int antalHunde, antalKatte, antalDyr;
    antalHunde = 5;
    antalKatte = 8; 

    <I>//udregn summen</I>
    antalDyr = antalHunde + antalKatte;

    <I>// udskriv resultatet</I>
    System.out.println(&quot;Antal dyr: &quot; + antalDyr);

    antalHunde  = 10;

    <I>// antalDyr er u&aelig;ndret</I>
    System.out.println(&quot;Antal dyr nu: &quot; + antalDyr);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Antal dyr: 13
Antal dyr nu: 13</PRE><P LANG="da-DK" CLASS="western">
Beregningen sker &eacute;n <SPAN STYLE="text-decoration: none">gang
</SPAN><I><SPAN STYLE="text-decoration: none">p&aring; det tidspunkt,
hvor kommandoen udf&oslash;res</SPAN></I><A CLASS="sdfootnoteanc" NAME="sdfootnote6anc" HREF="#sdfootnote6sym"><SUP>6</SUP></A>.
Derfor er <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">antalDyr</SPAN></SPAN></FONT></FONT>'s
v&aelig;rdi ikke p&aring;virket af at, vi s&aelig;tter <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">antalHunde</SPAN></SPAN></FONT></FONT>
til noget andet efter udregningen.</P>
<P LANG="da-DK" CLASS="western">Ligesom i almindelig matematik har *
(multiplikation) og / (division) h&oslash;jere prioritet end + og -.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">I Java skrives
<BR>  ”9 divideret med 3” som 9/3<BR>  ”3 gange 3” som 3*3</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Man kan ikke, som i almindelig
matematisk notation, undlade at skrive gangetegn.</P>
<P LANG="da-DK" CLASS="western">Resultatet af en heltalsudregning er
ogs&aring; et heltal. Det skal man v&aelig;re opm&aelig;rksom p&aring;
ved division, hvor eventuelle decimaler efter kommaet smides v&aelig;k.
Heltalsudregningen 13 / 5 giver alts&aring; 2, fordi 5 g&aring;r op i
13 to gange<A CLASS="sdfootnoteanc" NAME="sdfootnote7anc" HREF="#sdfootnote7sym"><SUP>7</SUP></A>.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Et heltal
divideret med et heltal giver et heltal <BR>  95 / 100 giver 0</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">&Oslash;nsker man at f&aring; et
kommatal som resultat af divisionen, skal et eller begge af tallene
v&aelig;re kommatal. Eksempelvis giver 95.0 / 10 kommatallet 9.5.</P>
<H3 CLASS="western">2.2.4 <a name='afsn2.2.4'></a>Kommatal</H3>
<P LANG="da-DK" CLASS="western">Der findes mange andre variabeltyper
end heltalstypen int. Hvis man vil regne med kommatal, bruger man
typen double. En variabel af typen double erkl&aelig;res med:</P>
<PRE CLASS="kode-western">  double h&oslash;jde;</PRE><P LANG="da-DK" CLASS="western">
De f&oslash;lgende afsnit bruger noget matematik, mange l&aelig;rer i
gymnasiet. Hvis du ikke kender s&aring; meget til matematik, g&oslash;r
det ikke noget. Pr&aelig;cis hvad der udregnes og formlerne bag det,
er ikke s&aring; vigtigt i denne sammenh&aelig;ng. Det vigtige er at
forst&aring; hvordan man arbejder med tal i Java.</P>
<P LANG="da-DK" CLASS="western" STYLE="">Her
er et eksempel p&aring; beregning af en cylinders rumfang:</P>
<PRE CLASS="kode-western"><I>//</I>
<I>// Beregning af rumfang for en cylinder</I>
<I>//</I>
public class Cylinderberegning
{
  public static void main(String[] arg) 
  {
<B>    double radius;</B>
<B>    radius = 5.0;</B>

<B>    double h&oslash;jde = 12.5;</B>

    <I>//beregn rumfang</I>
<B>    double volumen = radius * radius * h&oslash;jde * 3.14159;</B>

    System.out.println(&quot;Cylinderens h&oslash;jde: &quot; + h&oslash;jde);
    System.out.println(&quot;Cylinderens radius: &quot; + radius);
    System.out.println(&quot;Cylinderens volumen: &quot; + volumen);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Cylinderens h&oslash;jde: 12.5
Cylinderens radius: 5.0
Cylinderens volumen: 981.7468749999999</PRE><P LANG="da-DK" CLASS="western">
L&aelig;g m&aelig;rke til, at man godt kan erkl&aelig;re en variabel
og tildele den v&aelig;rdi i samme linje:</P>
<PRE CLASS="kode-western">  double h&oslash;jde = 12.5;</PRE><P LANG="da-DK" CLASS="western">
er alts&aring; det samme som:</P>
<PRE CLASS="kode-western">  double h&oslash;jde;
  h&oslash;jde = 12.5;</PRE><P LANG="da-DK" CLASS="western">
Her er et eksempel p&aring; en skatteberegning, der viser nogle flere
fif:</P>
<PRE CLASS="kode-western"><I>//</I>
<I>// Skatteberegning (Inspireret af Hallenberg og Sestoft, IT-C, K&oslash;benhavn)</I>
<I>//</I>
public class Skatteberegning 
{
  public static void main(String[] arg) 
  {
    double indkomst = 300000;
    double ambi, pension, bundskat;

    ambi = indkomst * 0.08;
    pension = indkomst * 0.01;
    indkomst = <B>indkomst - (ambi + pension)</B>;
    bundskat = <B>(indkomst - 33400) * 0.07</B>;

    System.out.println(&quot;AMBI: &quot; + ambi);
    System.out.println(&quot;S&aelig;rlig pensionsopsparing: &quot; + pension);
    System.out.println(&quot;Bundskat: &quot; + bundskat);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">AMBI: 24000.0
S&aelig;rlig pensionsopsparing: 3000.0
Bundskat: 16772.0</PRE><P LANG="da-DK" CLASS="western">
Udregninger sker normalt fra venstre mod h&oslash;jre, men ligesom i
den almindelige matematik kan man p&aring;virke
udregningsr&aelig;kkef&oslash;lgen. ved at s&aelig;tte parenteser:</P>
<PRE CLASS="kode-western">    bundskat = (indkomst - 33400) * 0.07;</PRE>
<H3 CLASS="western" STYLE="">2.2.5 <a name='afsn2.2.5'></a>Matematiske
funktioner</H3>
<P LANG="da-DK" CLASS="western">Dette afsnit handler om de
matematiske funktioner som sinus, cosinus, kvadratrod osv. som man
l&aelig;rer om i f.eks. den matematiske gren af gymnasiet. Kender du
ikke disse begreber s&aring; spring let hen over afsnittet, da de
<I>ikke</I> er n&oslash;dvendige for at l&aelig;re at programmere.</P>
<P LANG="da-DK" CLASS="western">Funktionerne kaldes i Java med
Math.sin(x) for sinus, Math.cos(x) for cosinus, Math.pow(x,&nbsp;y)
for potens, Math.sqrt(x) for kvadratrod, Math.sqr(x) for x<SUP>y</SUP>
osv., hvor x og y er variabler, faste tal eller beregningsudtryk.</P>
<P LANG="da-DK" CLASS="western">Vi kan f.eks. lave en tabel over
v&aelig;rdierne af kvadratrod-funktionen Math.sqrt() for x=0 til x=10
med programmet (senere, i <a href='kapitel2.jsp#afsn2.5'>afsnit 2.5</a> om l&oslash;kker vil vi se en
smartere m&aring;de).</P>
<PRE CLASS="kode-western">public class Kvadratrod
{
  public static void main(String[] arg) 
  {
    System.out.println(&quot;kvadratroden af 0 er &quot; + <B>Math.sqrt(0)</B>);
    System.out.println(&quot;kvadratroden af 1 er &quot; + Math.sqrt(1));
    System.out.println(&quot;kvadratroden af 2 er &quot; + Math.sqrt(2));
    System.out.println(&quot;kvadratroden af 3 er &quot; + Math.sqrt(3));
    System.out.println(&quot;kvadratroden af 4 er &quot; + Math.sqrt(4));
    System.out.println(&quot;kvadratroden af 5 er &quot; + Math.sqrt(5));
    System.out.println(&quot;kvadratroden af 6 er &quot; + Math.sqrt(6));
    System.out.println(&quot;kvadratroden af 7 er &quot; + Math.sqrt(7));
    System.out.println(&quot;kvadratroden af 8 er &quot; + Math.sqrt(8));
    System.out.println(&quot;kvadratroden af 9 er &quot; + Math.sqrt(9));
    System.out.println(&quot;kvadratroden af 10 er &quot; + Math.sqrt(10));
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">kvadratroden af 0 er 0.0
kvadratroden af 1 er 1.0
kvadratroden af 2 er 1.4142135623730951
kvadratroden af 3 er 1.7320508075688772
kvadratroden af 4 er 2.0
kvadratroden af 5 er 2.23606797749979
kvadratroden af 6 er 2.449489742783178
kvadratroden af 7 er 2.6457513110645907
kvadratroden af 8 er 2.8284271247461903
kvadratroden af 9 er 3.0
kvadratroden af 10 er 3.1622776601683795</PRE><P LANG="da-DK" CLASS="western">
Her er et program, der udregner l&aelig;ngden af den skr&aring; side
(hypotenusen) af en retvinklet trekant ud fra l&aelig;ngden af dens
to lige sider (kateter) a og b (kvadratroden af a&sup2;+b&sup2;):</P>
<PRE CLASS="kode-western">public class Trekant
{
  public static void main(String[] arg) 
  {
    double a, b, hypotenuse;
    a = 3;
    b = 4;
    hypotenuse = <B>Math.sqrt(a*a + b*b)</B>;
    System.out.println(&quot;En retvinklet trekant med sider &quot;+a+&quot; og &quot;+b);
    System.out.println(&quot;har hypotenuse &quot;+hypotenuse);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">En retvinklet trekant med sider 3.0 og 4.0
har hypotenuse 5.0</PRE><P LANG="da-DK" CLASS="western">
Her er et program, der udregner, hvor meget 1000 kroner med 5 % i
rente i 10 &aring;r bliver til:</P>
<PRE CLASS="kode-western">public class Rentesregning
{
  public static void main(String[] arg) 
  {
    System.out.println(&quot;1000 kr med 5 % i rente p&aring; 10 &aring;r giver &quot;
                       + 1000*<B>Math.pow(1.05 ,10)</B> + &quot; kroner.&quot;);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">1000 kr med 5 % i rente p&aring; 10 &aring;r giver 1628.8946267774422 kroner.</PRE><P LANG="da-DK" CLASS="western">
Ud over de almindelige matematiske funktioner findes ogs&aring;
Math.random(), der giver et tilf&aelig;ldigt tal mellem 0 og
0.999999...</P>
<H3 CLASS="western" STYLE="">2.2.6 <a name='afsn2.2.6'></a>Kald af
metoder</H3>
<P LANG="da-DK" CLASS="western">Math.sqrt(), Math.sin() og de andre
matematiske funktioner og andre kommandoer, f.eks.
System.out.println(), kaldes under et <I>metoder</I><SPAN STYLE="font-style: normal">.</SPAN></P>
<P LANG="da-DK" CLASS="western">En metode er en navngiven
programstump, der kan g&oslash;re et eller andet eller beregne en
v&aelig;rdi. F.eks. <I>g&oslash;r</I><SPAN STYLE="font-style: normal">
System</SPAN>.out.println() det, at den skriver tekst p&aring;
sk&aelig;rmen og Math.sqrt() <I>beregner </I><SPAN STYLE="font-style: normal">en
kvadratrod. N&aring;r en metode n&aelig;vnes i teksten, skriver vi
altid ”()” bagefter, s&aring; man kan se, at det er en metode.</SPAN></P>
<P LANG="da-DK" CLASS="western">Nedenst&aring;ende linje indeholder
et <I>metodekald</I>:</P>
<PRE CLASS="kode-western">    hypotenuse = <B>Math.sqrt(a*a + b*b)</B>;</PRE><P LANG="da-DK" CLASS="western">
Math.sqrt er navnet p&aring; metoden og man kalder det, der st&aring;r
inde i ”()”, for argumentet eller parameteren.</P>
<P LANG="da-DK" CLASS="western">Et metodekald er en n&aelig;vnelse af
en metodes navn efterfulgt af de rigtige parametre. Parametrene
er omgivet af parenteser. 
</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Ved et metodekald
kan man som parameter inds&aelig;tte ethvert udtryk, der giver et
resultat af den rigtige type</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Alt, der giver et resultat af den
rigtige type, er alts&aring; tilladt: Konstanter, variabler,
regneudtryk og resultatet af et andet metodekald:</P>
<PRE CLASS="kode-western">    double v,x;
    x = Math.sqrt(100);             <I>// konstant som parameter</I>
    x = Math.sqrt(x);               <I>// variabel som parameter</I>
    x = Math.sin(Math.sqrt(0.3));  <I>// v&aelig;rdi af andet metodekald som parameter</I></PRE><P LANG="da-DK" CLASS="western">
Ved et kald uden parametre skal man stadig have parenteserne med. Her
er et eksempel p&aring; et metodekald af Math.random(), som er en
metode, der skal kaldes uden parametre:</P>
<PRE CLASS="kode-western">    double tilf&aelig;ldigtTal; 
    tilf&aelig;ldigtTal = Math.random();</PRE><P LANG="da-DK" CLASS="western">
Vi vil i <a href='kapitel4.jsp'>kapitel 4</a> se, hvad der sker, n&aring;r computeren udf&oslash;rer
et metodekald samt l&aelig;re, hvordan man kan lave sine egne
metoder.</P>
<H3 CLASS="western">2.2.7 <a name='afsn2.2.7'></a>Logiske variabler</H3>
<P LANG="da-DK" CLASS="western">En boolesk<A CLASS="sdfootnoteanc" NAME="sdfootnote8anc" HREF="#sdfootnote8sym"><SUP>8</SUP></A>
variabel (eng.: boolean), ogs&aring; kaldet en logisk variabel, kan
indeholde v&aelig;rdien sand eller falsk. Den bruges mest til at
huske, om noget er sandt eller ej, men kan ogs&aring; repr&aelig;sentere
noget, der kun har to tilstande, f.eks. om en lampe er t&aelig;ndt
eller slukket.</P>
<P LANG="da-DK" CLASS="western">Variabeltypen hedder boolean og den
erkl&aelig;res med f.eks.:</P>
<PRE CLASS="kode-western">    boolean detErForSent;</PRE><P LANG="da-DK" CLASS="western">
En boolesk variabel kan kun s&aelig;ttes til v&aelig;rdierne true
eller false. F.eks.:</P>
<PRE CLASS="kode-western">    detErForSent = false;</PRE><P LANG="da-DK" CLASS="western">
P&aring; h&oslash;jre side af lighedstegnet kan st&aring; et logisk
udtryk, dvs. et udsagn, der enten er sandt eller falsk, f.eks.
&quot;klokken er over 8&quot; (her forestiller vi os, at vi har
variablen klokken).</P>
<PRE CLASS="kode-western">    detErForSent = klokken &gt; 8;</PRE><P LANG="da-DK" CLASS="western">
Udtrykket <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">klokken
&gt; 8</SPAN></SPAN></FONT></FONT> unders&oslash;ges af Java, ved at
inds&aelig;tte v&aelig;rdien af variablen i regneudtrykket og
derefter afg&oslash;re, om udsagnet er sandt. Hvis f.eks. <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">klokken</SPAN></SPAN></FONT></FONT>
er lig 7, st&aring;r der <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">7&gt;8</SPAN></SPAN></FONT></FONT>,
det er ikke sandt og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">detErForSent</SPAN></SPAN></FONT></FONT>
f&aring;r v&aelig;rdien false. Hvis <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">klokken</SPAN></SPAN></FONT></FONT>
er lig 10, st&aring;r der <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">10&gt;8</SPAN></SPAN></FONT></FONT>,
det er sandt og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">detErForSent</SPAN></SPAN></FONT></FONT>
f&aring;r v&aelig;rdien true.</P>
<H3 CLASS="western" STYLE="">2.2.8 <a name='afsn2.2.8'></a>Opgaver</H3>
<OL>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, som ud fra
  l&aelig;ngde og bredde p&aring; et rektangel udskriver dets areal.</P>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, som for
  ligningen y=3*x*x+6*x+9 udskriver v&aelig;rdien af y for x=7.</P>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, som omregner
  et bel&oslash;b fra dollar til euro (f.eks. kurs 95).</P>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, som udskriver
  tre tilf&aelig;ldige tal (lavet med Math.random()), deres sum og
  gennemsnittet.</P>
  <LI><P LANG="da-DK" CLASS="western">Hvad skriver f&oslash;lgende
  program ud? Hvis du kan regne det ud, <I>uden</I> at k&oslash;re
  programmet, har du forst&aring;et id&eacute;en i tildelinger.</P>
</OL>
<PRE CLASS="kode-western">public class Tildelinger
{
  public static void main(String[] arg)
  {
    int a, b, c, d;
    a = 5;
    b = 6;
    c = 7;
    d = 8;
    System.out.println(&quot;a er &quot;+a+&quot;, b er &quot;+b+&quot;, c er &quot;+c+&quot; og d er &quot;+d);

    a = b + d;
    d = c + a;
    System.out.println(&quot;a er &quot;+a+&quot;, b er &quot;+b+&quot;, c er &quot;+c+&quot; og d er &quot;+d);

    b = a;
    d = c;
    System.out.println(&quot;a er &quot;+a+&quot;, b er &quot;+b+&quot;, c er &quot;+c+&quot; og d er &quot;+d);
  }
}</PRE>
<H2 CLASS="western">2.3 <a name='afsn2.3'></a>Betinget udf&oslash;relse</SPAN></H2>
<P LANG="da-DK" CLASS="western">Indtil nu har vores programmer v&aelig;ret
fuldst&aelig;ndig forudsigelige. Vi har bedt computeren om at udf&oslash;re
den ene kommando efter den anden uanset udfaldet af de tidligere
kommandoer.</P>
<P LANG="da-DK" CLASS="western"><SPAN ID="Ramme11" DIR="LTR" STYLE="float: right; width: 5.98cm; height: 3.14cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog3_html_1e44109a.gif" NAME="Objekt41" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>Logikken
  i en if-s&aelig;tning</I></FONT></P>
</SPAN>I programmer kan man p&aring;virke programudf&oslash;relsen,
ved at indf&oslash;re betingelser, der fort&aelig;ller, at en del af
programmet kun skal genneml&oslash;bes, hvis betingelsen er opfyldt.
</P>
<P LANG="da-DK" CLASS="western">Det best&aring;r af et udtryk, der
enten er sandt eller falsk og noget, der afh&aelig;nger af dets
sandhedsv&aelig;rdi (se rutediagrammet til h&oslash;jre).</P>
<P LANG="da-DK" CLASS="western">Alle kender betingelser fra deres
dagligdag, f.eks.:</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western">hvis du er over 18, er du
  myndig.</P>
  <LI><P LANG="da-DK" CLASS="western">hvis din alkoholpromille er
  st&oslash;rre end 0.5, s&aring; lad bilen st&aring;.</P>
  <LI><P LANG="da-DK" CLASS="western">hvis den koster mindre end 500
  kr, s&aring; k&oslash;b den!</P>
</UL>


<P LANG="da-DK" CLASS="western" STYLE="">I
Java er syntaksen</P>
<PRE CLASS="kode-western">    if (<I>betingelse</I>) <I>kommando;</I></PRE><P LANG="da-DK" CLASS="western">
For eksempel:</P>
<PRE CLASS="kode-western">if (alder &gt;= 18) System.out.println(&quot;Du er myndig&quot;);

if (alkoholpromille &gt; 0.5) System.out.println(&quot;Lad bilen st&aring;&quot;);

if (pris &lt; 500) System.out.println(&quot;Jeg k&oslash;ber den!&quot;);

if (alder == 18) System.out.println(&quot;Du er pr&aelig;cis atten &aring;r.&quot;);

if (alder != 18) System.out.println(&quot;Du er ikke atten.&quot;);</PRE><P LANG="da-DK" CLASS="western">
Udtrykkene i parenteserne er logiske udtryk (eller booleske udtryk).
P&aring; dansk er s&aelig;tningen &quot;over 18&quot; tvetydig: skal
man v&aelig;re OVER 18, dvs. 19, for at v&aelig;re myndig? Java har
derfor to forskellige sammenligningsoperatorer: a &gt;= b unders&oslash;ger,
om a er st&oslash;rre end eller lig med b, mens a &gt; b unders&oslash;ger
om a er st&oslash;rre end b. I appendiks <a href='kapitel2.jsp#afsn2.11.6'>afsnit 2.11.6</a> findes en
oversigt over sammenligningsoperatorerne.</P>
<P LANG="da-DK" CLASS="western"><SPAN ID="Ramme12" DIR="LTR" STYLE="float: right; width: 6.1cm; height: 3.25cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog3_html_m1725ff3f.gif" NAME="Objekt42" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>Rutediagram
  for Alder</I></FONT></P>
</SPAN>Herunder et komplet eksempel p&aring; et program, der afg&oslash;r,
om man er myndig. Programkoden, udtrykt p&aring; dansk, kunne v&aelig;re:
hvis alder er st&oslash;rre end 18, s&aring; skriv &quot;Du er
myndig&quot;. I Java skriver man:
</P>
<PRE CLASS="kode-western">public class Alder
{
  public static void main(String[] arg) 
  {
    int alder;
    alder = 15;

<B>    if (alder &gt;= 18)</B> <B>System.out.println(&quot;Du er myndig.&quot;);</B>

    System.out.println(&quot;Du er &quot; + alder + &quot; &aring;r.&quot;);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western" STYLE="; ">Du er 15 &aring;r.</PRE><P LANG="da-DK" CLASS="western">
Kommandoen System.out.println(&quot;Du er myndig&quot;) bliver kun
udf&oslash;rt, hvis betingelsen (<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">alder
&gt;= 18</SPAN></SPAN></FONT></FONT>) er sand. I dette tilf&aelig;lde
er <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">alder</SPAN></SPAN></FONT></FONT>
lig 15 og der bliver ikke skrevet noget ud. 
</P>
<P LANG="da-DK" CLASS="western">Hvis vi &aelig;ndrer i programmet, s&aring;
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">alder</SPAN></SPAN></FONT></FONT>
er 18, er betingelsen (<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">alder
&gt;= 18</SPAN></SPAN></FONT></FONT>) sand og vi f&aring;r:</P>
<PRE CLASS="kode-western">Du er myndig.
Du er 18 &aring;r.</PRE><P LANG="da-DK" CLASS="western">
Programudf&oslash;relsen forts&aelig;tter under alle omst&aelig;ndigheder
efter betingelsen, s&aring; uafh&aelig;ngigt af udfaldet, vil den
sidste linje blive udf&oslash;rt.</P>
<H3 CLASS="western">2.3.1 <a name='afsn2.3.1'></a>Indl&aelig;sning fra tastaturet</H3>
<P LANG="da-DK" CLASS="western">Et program bliver selvf&oslash;lgelig
f&oslash;rst rigtigt sjovt, hvis brugeren kan p&aring;virke dets
udf&oslash;relse, f.eks. ved at programmet kan bede brugeren om at
indtaste sin alder. Det kan g&oslash;res med:</P>
<PRE CLASS="kode-western">public class AlderMedTastaturindlaesning
{
  public static void main(String[] arg) 
  {
    <B>java.util.Scanner </B>tastatur = new java.util.Scanner(System.in);  <I>// forbered</I>

    System.out.println(&quot;Skriv din alder herunder og tryk retur:&quot;);
    int alder;
    <B>alder = tastatur.nextInt();                    </B> <I>// l&aelig;s et tal fra tastaturet</I>

    if (alder &gt;= 18) System.out.println(&quot;Du er myndig.&quot;);
    System.out.println(&quot;Du er &quot; + alder + &quot; &aring;r.&quot;);
  }
}</PRE><P LANG="da-DK" CLASS="western">
Programmet vil nu stoppe op og vente p&aring;, at der bliver
indtastet noget efterfulgt af tryk p&aring; retur-tasten. Den &oslash;verste
linje (med kommentaren <I>forbered</I>) skal kun forekomme &eacute;n
gang &oslash;verst i programmet (i <a href='kapitel3.jsp'>kapitel 3</a> vil vi se n&aelig;rmere
p&aring;, hvad der sker i de to specielle linjer). 
</P>
<P LANG="da-DK" CLASS="western">Du kan ogs&aring; f&aring; et grafisk
indtastningsvindue, som brugeren kan udfylde til at dukke op (se
<a href='kapitel2.jsp#afsn2.12.1'>afsnit 2.12.1</a>).</P>
<H3 CLASS="western">2.3.2 <a name='afsn2.3.2'></a>if-else</H3>
<P LANG="da-DK" CLASS="western"><SPAN ID="Ramme20" DIR="LTR" STYLE="float: right; width: 5.97cm; height: 5.35cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog3_html_6de57b81.gif" NAME="Objekt43" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>Logikken
  i en if-else-s&aelig;tning</I></FONT></P>
</SPAN>Hvis vi &oslash;nsker at g&oslash;re &eacute;n ting, hvis
betingelsen er sand og en anden ting, hvis betingelsen er falsk, kan
vi f&oslash;je en else-del til vores if-s&aelig;tning. Denne del vil
kun blive udf&oslash;rt, hvis betingelsen er falsk. Syntaksen er:
</P>
<PRE CLASS="kode-western">    if (<I>betingelse</I>) <I>kommando1;</I>
<I>    else kommando2;</I></PRE>
<P LANG="da-DK" CLASS="western">Eksempelvis:</P>
<PRE CLASS="kode-western" STYLE="; ">public class Alder2
{
  public static void main(String[] arg) 
  {
    int alder;
    alder = 15;

<B>    if (alder &gt;= 18)</B>
      System.out.println(&quot;Du er myndig.&quot;);
    <B>else</B>
<B>      </B>System.out.println(&quot;Du er ikke myndig.&quot;);

    System.out.println(&quot;Du er &quot; + alder + &quot; &aring;r.&quot;);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western" STYLE="">Du er ikke myndig.
Du er 15 &aring;r.</PRE><P LANG="da-DK" CLASS="western">
&AElig;ndrer vi <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">alder
= 15</SPAN></SPAN></FONT></FONT> til <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">alder
= 18</SPAN></SPAN></FONT></FONT>, er betingelsen (<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">alder
&gt;= 18</SPAN></SPAN></FONT></FONT>) sand og vi f&aring;r i stedet
udskriften:</P>
<PRE CLASS="kode-western">Du er myndig.
Du er 18 &aring;r.</PRE><H4 CLASS="western">
K&aelig;dede if-else-s&aelig;tninger</H4>
<P LANG="da-DK" CLASS="western">Bem&aelig;rk at man med fordel kan
k&aelig;de if-else-s&aelig;tninger sammen. F.eks.:</P>
<PRE CLASS="kode-western" STYLE=""><B>    if (alder &gt;= 18) </B>System.out.println(&quot;Du er myndig.&quot;);
    <B>else</B> <B>if (alder &gt;= 13) </B>System.out.println(&quot;Du er teenager og ikke myndig.&quot;);
    <B>else</B> <B>if (alder &gt;= 2) </B>System.out.println(&quot;Du er et barn og ikke myndig.&quot;);
<B>    else </B>System.out.println(&quot;Du er et sp&aelig;dbarn!&quot;);</PRE><H3 CLASS="western">
2.3.3 <a name='afsn2.3.3'></a>Opgaver</H3>
<OL>
  <LI><P LANG="da-DK" CLASS="western">Skriv Alder2 om til at indeholde
  flere aldergr&aelig;nser.</P>
  <LI><P LANG="da-DK" CLASS="western">Lav et veksleprogram fra dollar
  til euro. Det skal p&aring;regne en kommission p&aring; 2 %, dog
  mindst 0,5 euro. 
  </P>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, der beregner
  porto for et brev. Inddata er brevets v&aelig;gt (i gram). Uddata
  er prisen, for at sende det som A-post i Danmark.</P>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, som finder det
  st&oslash;rste og det mindste af tre tal.</P>
</OL>
<P LANG="da-DK" CLASS="western">Afpr&oslash;v programmerne med
forskellige v&aelig;rdier, ved at indl&aelig;se v&aelig;rdierne fra
tastaturet.</P>
<H2 CLASS="western" STYLE="">2.4 <a name='afsn2.4'></a>Blokke</SPAN></H2>
<P LANG="da-DK" CLASS="western">En blok er en samling af kommandoer.
Den starter med en blokstart-parentes { og slutter med en
blokslut-parentes}.<A CLASS="sdfootnoteanc" NAME="sdfootnote9anc" HREF="#sdfootnote9sym"><SUP>9</SUP></A></P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">En blok grupperer
flere kommandoer, s&aring; de udf&oslash;res samlet</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Blokke bruges blandt andet, hvis man
vil have mere end f&oslash;rstkommende linje udf&oslash;rt i en
betingelse. Herunder udf&oslash;res to kommandoer, hvis betingelsen
er opfyldt og to andre kommandoer, hvis betingelsen ikke er opfyldt:</P>
<PRE CLASS="kode-western">public class Alder3
{
  public static void main(String[] arg) 
  {
    int alder;
    alder = 15;

    if (alder &gt;= 18) 
    <B>{</B><I><SPAN STYLE="font-weight: medium">                                                   // blokstart</SPAN></I>
      System.out.println(&quot;Du er &quot; + alder + &quot; &aring;r.&quot;);
      System.out.println(&quot;Du er myndig.&quot;);
    <B>}</B><I><SPAN STYLE="font-weight: medium">                                                   // blokslut</SPAN></I> 
    else 
    <B>{</B><I><SPAN STYLE="font-weight: medium">                                                   // blokstart</SPAN></I>
      System.out.println(&quot;Du er kun &quot; + alder + &quot; &aring;r.&quot;);
      System.out.println(&quot;Du er ikke myndig.&quot;);
    <B>}</B><I><SPAN STYLE="font-weight: medium">                                                   // blokslut</SPAN></I>
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Du er kun 15 &aring;r.
Du er ikke myndig.</PRE><H3 CLASS="western">
2.4.1 <a name='afsn2.4.1'></a>Indrykning</H3>
<P LANG="da-DK" CLASS="western">L&aelig;g m&aelig;rke til, hvordan
programkoden i blokkene i ovenst&aring;ende eksempel er rykket lidt
ind. Det g&oslash;r det lettere for programm&oslash;ren at overskue
koden, s&aring; han/hun kan se, hvilken {-parentes der h&oslash;rer
sammen med hvilken }-parentes<A CLASS="sdfootnoteanc" NAME="sdfootnote10anc" HREF="#sdfootnote10sym"><SUP>10</SUP></A>.
</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Det er god skik
at bruge indrykning i en blok</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Indrykning g&oslash;r
programmet meget nemmere at overskue</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Her er det samme program uden
indrykning. Det er sv&aelig;rere at overskue nu (man kunne m&aring;ske
komme til at tro, at de nederste to linjer bliver udf&oslash;rt
uafh&aelig;ngigt af if-s&aelig;tningen):</P>
<PRE CLASS="kode-western">public class Alder3UheldigIndrykning{
public static void main(String[] arg) 
{int alder;
alder = 15;
if (alder &gt;= 18) { System.out.println(&quot;Du er &quot; + alder + &quot; &aring;r.&quot;);
System.out.println(&quot;Du er myndig&quot;);
} else {
System.out.println(&quot;Du er kun &quot; + alder + &quot; &aring;r.&quot;);
System.out.println(&quot;Du er ikke myndig&quot;);
}}}</PRE><P LANG="da-DK" CLASS="western">
De fleste udviklingsv&aelig;rkt&oslash;jer har funktioner til at
rykke flere linjers kode ind og ud. Man g&oslash;r det oftest, ved at
markere teksten og trykke p&aring; Tab (tabulator-tasten til venstre
for Q).</P>
<H2 CLASS="western">2.5 <a name='afsn2.5'></a>L&oslash;kker</SPAN></H2>
<P LANG="da-DK" CLASS="western">En l&oslash;kke er en gentaget
udf&oslash;relse af en kommando igen og igen. Hvor mange gange
l&oslash;kken udf&oslash;res, afh&aelig;nger af et logisk
udtryk.</P>
<H3 CLASS="western">2.5.1 <a name='afsn2.5.1'></a>while-l&oslash;kken</H3>
<P LANG="da-DK" CLASS="western"><SPAN ID="Ramme21" DIR="LTR" STYLE="float: right; width: 6.08cm; height: 3.2cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog3_html_5d5a05d1.gif" NAME="Objekt44" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>Logikken
  i en while-l&oslash;kke</I></FONT></P>
</SPAN>while-l&oslash;kken har formen:
</P>
<PRE CLASS="kode-western">    while (<I>betingelse</I>) <I>kommando;</I></PRE><P LANG="da-DK" CLASS="western">
Kommandoen udf&oslash;res igen og igen, s&aring; l&aelig;nge
betingelsen er opfyldt. Dvs. f&oslash;r kommandoen udf&oslash;res,
unders&oslash;ges betingelsen og det kontrolleres, at den er opfyldt
(se rutediagrammet til h&oslash;jre).</P>
<P LANG="da-DK" CLASS="western">Oftest vil man udf&oslash;re mere en
&eacute;n kommando og anvender derfor en blok til samle kommandoerne:</P>
<PRE CLASS="kode-western">    while (<I>betingelse</I>) {
      kommando1;
      kommando2;
      ...
    }</PRE><P LANG="da-DK" CLASS="western">
Her er et eksempel:</P>
<PRE CLASS="kode-western" STYLE="; ">public class Alder4
{
  public static void main(String[] arg) 
  {
    int alder;
    alder = 15;

    <B>while (alder &lt; 18)</B>
    <B>{</B>
      System.out.println(&quot;Du er &quot;+alder+&quot; &aring;r. Vent til du bliver &aelig;ldre.&quot;);
      alder = alder + 1;
      System.out.println(&quot;Tillykke med f&oslash;dselsdagen!&quot;);
    <B>}</B>

    System.out.println(&quot;Nu er du &quot;+alder+&quot; &aring;r og myndig.&quot;);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western" STYLE="">Du er 15 &aring;r. Vent til du bliver &aelig;ldre.
Tillykke med f&oslash;dselsdagen!
Du er 16 &aring;r. Vent til du bliver &aelig;ldre.
Tillykke med f&oslash;dselsdagen!
Du er 17 &aring;r. Vent til du bliver &aelig;ldre.
Tillykke med f&oslash;dselsdagen!
Nu er du 18 &aring;r og myndig.</PRE><P LANG="da-DK" CLASS="western">
F&oslash;r l&oslash;kken starter, har <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">alder</SPAN></SPAN></FONT></FONT>
en startv&aelig;rdi p&aring; 15. Under hvert genneml&oslash;b t&aelig;lles
den en op. 
</P>
<P LANG="da-DK" CLASS="western">P&aring; et tidspunkt, n&aring;r
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">alder</SPAN></SPAN></FONT></FONT>
er talt op til 18, er betingelsen ikke mere opfyldt og
programudf&oslash;relsen forts&aelig;tter efter l&oslash;kken.</P>
<P LANG="da-DK" CLASS="western"><SPAN ID="Ramme15" DIR="LTR" STYLE="float: right; width: 6.14cm; height: 4.61cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog3_html_m29bea4aa.gif" NAME="Objekt45" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>Rutediagram
  for noget af Alder4</I></FONT></P>
</SPAN><BR><BR>
</P>
<P LANG="da-DK" CLASS="western" STYLE="">Med
en l&oslash;kke kan vi lave Kvadratrod-programmet nemmere: I stedet
for at skrive den samme kommando igen og igen, kan vi lave en
l&oslash;kke. 
</P>
<P LANG="da-DK" CLASS="western">Sammenlign det f&oslash;lgende
program med det oprindelige Kvadratrod-program fra <a href='kapitel2.jsp#afsn2.2.5'>afsnit 2.2.5</a>.</P>
<PRE CLASS="kode-western">public class Kvadratrod2
{
  public static void main(String[] arg) 
  {
    int n;
    n = 0;


    while (n &lt;= 10)
    {
      System.out.println(&quot;kvadratroden af &quot;+n+&quot; er &quot; + <B>Math.sqrt(n)</B>);
      n = n + 1;
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">kvadratroden af 0 er 0.0
kvadratroden af 1 er 1.0
kvadratroden af 2 er 1.4142135623730951
kvadratroden af 3 er 1.7320508075688772
kvadratroden af 4 er 2.0
kvadratroden af 5 er 2.23606797749979
kvadratroden af 6 er 2.449489742783178
kvadratroden af 7 er 2.6457513110645907
kvadratroden af 8 er 2.8284271247461903
kvadratroden af 9 er 3.0
kvadratroden af 10 er 3.1622776601683795</PRE><P LANG="da-DK" CLASS="western">
En t&aelig;llevariabel er en variabel, der t&aelig;lles op i en
l&oslash;kke, indtil den n&aring;r en bestemt &oslash;vre gr&aelig;nse,
hvorefter l&oslash;kken afbrydes. 
</P>
<P LANG="da-DK" CLASS="western">I eksemplerne ovenfor brugte vi <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">alder</SPAN></SPAN></FONT></FONT>
og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">n</SPAN></SPAN></FONT></FONT>
som t&aelig;llevariabler.</P>
<P LANG="da-DK" CLASS="western">Herunder udskriver vi 7-tabellen, ved
hj&aelig;lp af t&aelig;llevariablen <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">n</SPAN></SPAN></FONT></FONT>:</P>
<DIV ID="Ramme19" DIR="LTR" STYLE="float: right; width: 5.58cm; height: 3.97cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog3_html_m2a30832e.gif" NAME="Objekt46" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>Rutediagram
  for Syvtabel</I></FONT></P>
</DIV>
<PRE CLASS="kode-western">public class Syvtabel
{
  public static void main(String[] arg) 
  {
    int n;
    n = 1;

    while (n &lt;= 10)
    {
      System.out.println(n+&quot; : &quot;+ 7*n);
      n = n + 1;
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">1 : 7
2 : 14
3 : 21
4 : 28
5 : 35
6 : 42
7 : 49
8 : 56
9 : 63
10 : 70</PRE><P LANG="da-DK" CLASS="western">
T&aelig;llevariabel-formen er den mest almindelige for l&oslash;kker,
men man kan sagtens komme ud for andre former for l&oslash;kker. Der
kan f.eks. godt indg&aring; et regneudtryk i betingelsen.</P>
<H3 CLASS="western" STYLE="">2.5.2 <a name='afsn2.5.2'></a>for-l&oslash;kken</H3>
<P LANG="da-DK" CLASS="western">for-l&oslash;kken er specielt
velegnet til l&oslash;kker med en t&aelig;llevariabel. Den har formen</P>
<PRE CLASS="kode-western">    for (<I>initialisering</I>; <I>betingelse</I>; <I>opdatering</I>) <I>kommando;</I></PRE><P LANG="da-DK" CLASS="western">
<SPAN ID="Ramme13" DIR="LTR" STYLE="float: right; width: 5.81cm; height: 4.01cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=LEFT STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog3_html_m23442153.gif" NAME="Objekt47" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>Strukturen
  i en for-l&oslash;kke</I></FONT></P>
</SPAN><BR><BR>
</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western"><I>initialisering</I> er en
  (evt.: erkl&aelig;ring og) tildeling af en t&aelig;llevariabel,
  <BR>  f.eks. <FONT FACE="Courier New, monospace">alder = 15</FONT></P>
  <LI><P LANG="da-DK" CLASS="western"><I>betingelse</I> er et logisk
  udtryk, der angiver betingelsen for, at l&oslash;kken skal
  forts&aelig;tte med at blive udf&oslash;rt,<BR>  f.eks. <FONT FACE="Courier New, monospace">alder
  &lt; 18</FONT></P>
  <LI><P LANG="da-DK" CLASS="western"><I>opdatering</I> er &aelig;ndringen
  i t&aelig;llevariablen, <BR>   f.eks. <FONT FACE="Courier New, monospace">alder
  = alder + 1</FONT></P>
</UL>
<P LANG="da-DK" CLASS="western">Det kan indenad l&aelig;ses som &quot;for
<I>startv&aelig;rdi</I>, s&aring; l&aelig;nge <I>betingelse</I>
udf&oslash;r: <I>kommando</I> og <I>opdatering</I>, f.eks. &quot;for
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent"><I>alder</I></SPAN></SPAN></FONT></FONT><I>
= 15</I>, s&aring; l&aelig;nge <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent"><I>alder</I></SPAN></SPAN></FONT></FONT><I>
&lt; 18</I> udf&oslash;r: <I>Skriv &quot;du er..&quot;</I> og <I>t&aelig;l
</I><FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent"><I>alder</I></SPAN></SPAN></FONT></FONT><I>
1 op&quot;</I>.</P>

<P LANG="da-DK" CLASS="western"><SPAN ID="Ramme16" DIR="LTR" STYLE="float: right; width: 5.58cm; height: 3.97cm; border: none; padding: 0cm; background: #ffffff">
  <P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
  <IMG SRC="bog3_html_m2a30832e.gif" NAME="Objekt48" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I>Rutediagram
  for Syvtabel2<BR>(samme som for Syvtabel)</I></FONT></P>
</SPAN>En for-l&oslash;kke og en while-l&oslash;kke supplerer
hinanden. De har pr&aelig;cis samme funktion, men for-l&oslash;kken
er mere kompakt og bekvem, n&aring;r man &oslash;nsker at lave en
almindelig l&oslash;kke, der udf&oslash;res et bestemt antal gange.
Dette program g&oslash;r det samme som Syvtabel-eksemplet, men med en
for-l&oslash;kke:
</P>
<PRE CLASS="kode-western">public class Syvtabel2
{
  public static void main(String[] arg) 
  {
    int n;
<B>    for (n=1; n&lt;=10; n=n+1)</B>
      System.out.println(n+&quot; : &quot;+ 7*n);
  }
}</PRE><P LANG="da-DK" CLASS="western">
Programm&oslash;rer er dovne v&aelig;sner og bruger ofte for-l&oslash;kken
til opt&aelig;lling, fordi der skal skrives mindre end i en
while-l&oslash;kke. 
</P>
<P LANG="da-DK" CLASS="western">Man ser ogs&aring; ofte, at de bruger
operatoren <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">++</SPAN></SPAN></FONT></FONT>
til at t&aelig;lle en variabel op i en l&oslash;kke: &quot;<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">alder++</SPAN></SPAN></FONT></FONT>&quot;
svarer alts&aring; til &quot;<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">alder=alder+1</SPAN></SPAN></FONT></FONT>&quot;,
men med mindre skrivearbejde. 
</P>
<P LANG="da-DK" CLASS="western">Tilsvarende findes <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">-</SPAN></SPAN></FONT></FONT><FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">-</SPAN></SPAN></FONT></FONT>,
som t&aelig;ller en variabel &eacute;n ned, f.eks. <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">alder</SPAN></SPAN></FONT></FONT><FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">-</SPAN></SPAN></FONT></FONT><FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">-</SPAN></SPAN></FONT></FONT>.</P>
<H3 CLASS="western" STYLE="">2.5.3 <a name='afsn2.5.3'></a>Indlejrede
l&oslash;kker</H3>
<P LANG="da-DK" CLASS="western">En betingelse eller en l&oslash;kke
kan st&aring; ethvert sted i en metode og alts&aring; ogs&aring;
inden i en anden l&oslash;kke eller en betingelse. 
</P>
<P LANG="da-DK" CLASS="western">Herunder har vi syvtabellen igen, men
denne gang &quot;brokker&quot; programmet sig, n&aring;r det n&aring;r
op p&aring; 6. Efter 8 skriver det &quot;ved ikke&quot;, i stedet for
at regne resultatet ud.</P>
<PRE CLASS="kode-western">public class Syvtabel3
{
  public static void main(String[] arg) 
  {
    <B>for (int n=1; n&lt;=10; n++)</B>  <I>// n++ g&oslash;r det samme som n=n+1</I>
    {
      <B>if (n == 6)</B> System.out.println(&quot;puha, nu bliver det sv&aelig;rt.&quot;);

      <B>if (n &lt; 8)  </B> System.out.println(n+&quot; : &quot;+ 7*n);
      <B>else</B> System.out.println(n+&quot; : (ved ikke)&quot;);
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">1 : 7
2 : 14
3 : 21
4 : 28
5 : 35
puha, nu bliver det sv&aelig;rt.
6 : 42
7 : 49
8 : (ved ikke)
9 : (ved ikke)
10 : (ved ikke)</PRE>
<P LANG="da-DK" CLASS="western">Man kan lave l&oslash;kker i l&oslash;kker.
Herunder udregner vi n*7 ved at l&aelig;gge 7 sammen n gange:</P>
<PRE CLASS="kode-western">public class Syvtabel4
{
  public static void main(String[] arg) 
  {
    for (int n=1; n&lt;=10; n=n+1)
    {
      int sum = 0;
      for (int j=0; j&lt;n; j++) sum = sum + 7;

      System.out.println(n+&quot; : &quot;+ sum);
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">1 : 7
2 : 14
3 : 21
4 : 28
5 : 35
6 : 42
7 : 49
8 : 56
9 : 63
10 : 70</PRE>
<H3 CLASS="western" STYLE="">2.5.4 <a name='afsn2.5.4'></a>Uendelige
l&oslash;kker</H3>
<P LANG="da-DK" CLASS="western">Hvis programm&oslash;ren ikke er
omhyggelig, kan han komme til at lave en l&oslash;kke, hvor
betingelsen vedbliver at v&aelig;re sand. S&aring; bliver
programudf&oslash;relsen i l&oslash;kken i al evighed (eller indtil
brugeren afbryder programmet). 
</P>
<P LANG="da-DK" CLASS="western">Lad os f.eks. sige, at programm&oslash;ren
er kommet til at skrive '-' i stedet for '+' i opdateringen af <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">n</SPAN></SPAN></FONT></FONT>
i while-l&oslash;kken fra Syvtabel-programmet. Nu vil computeren
t&aelig;lle nedad:</P>
<PRE CLASS="kode-western">public class SyvtabelFejl
{
  public static void main(String[] arg) 
  {
    for (int n=1; n&lt;=10; <B>n=n-1</B>)
      System.out.println(n+&quot; : &quot;+ 7*n);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">1 : 7
0 : 0
-1 : -7
-2 : -14
-3 : -21
-4 : -28</PRE><P LANG="da-DK" CLASS="western">
... og s&aring; videre i det uendelige. L&oslash;kken vil aldrig
stoppe, fordi <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">n</SPAN></SPAN></FONT></FONT>
vedbliver at v&aelig;re mindre end<A CLASS="sdfootnoteanc" NAME="sdfootnote11anc" HREF="#sdfootnote11sym"><SUP>11</SUP></A>
10.</P>
<P LANG="da-DK" CLASS="western">En anden faldgrube er, at komme til
at s&aelig;tte et semikolon efter en while-l&oslash;kke:</P>
<PRE CLASS="kode-western">    while (n &lt;= 10)<B>;</B></PRE><P LANG="da-DK" CLASS="western">
Overs&aelig;tteren vil tro, at der ikke er nogen kommando, der skal
udf&oslash;res og blot unders&oslash;ge betingelsen igen og igen og
igen og igen... Da <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">n</SPAN></SPAN></FONT></FONT>
ikke &aelig;ndrer sig, vil programmet aldrig stoppe.</P>
<P LANG="da-DK" CLASS="western">Det er programm&oslash;rens ansvar at
sikre, at betingelsen i en l&oslash;kke p&aring; et tidspunkt ikke
mere opfyldes, s&aring; programmet ikke g&aring;r i uendelig l&oslash;kke<A CLASS="sdfootnoteanc" NAME="sdfootnote12anc" HREF="#sdfootnote12sym"><SUP>12</SUP></A>.</P>
<H3 CLASS="western">2.5.5 <a name='afsn2.5.5'></a>Opgaver</H3>
<P LANG="da-DK" CLASS="western">Pr&oslash;v at k&oslash;re hvert af
de foreg&aring;ende eksempler og forvis dig om, at du forst&aring;r
dem.<BR>Mange v&aelig;rkt&oslash;jer underst&oslash;tter trinvis
gennemgang til fejlfinding (eng.: debugging). Pr&oslash;v i dit
udviklingsv&aelig;rkt&oslash;j og hold &oslash;je med variablerne
(g&oslash;res nok med F8-tasten &quot;step over&quot;).</P>
<OL>
  <LI><P LANG="da-DK" CLASS="western">Lav et program, der t&aelig;ller
  nedad fra 10 til 1.</P>
  <LI><P LANG="da-DK" CLASS="western">Lav et program, der udregner
  v&aelig;rdien af 1+2+3+ ... +20 med en l&oslash;kke.</P>
  <LI><P LANG="da-DK" CLASS="western">Lav et program, der udskriver
  2-tabellen, 3-tabellen, .. op til 10-tabellen.</P>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, som for
  ligningen y=3*x*x+6*x+9 udskriver v&aelig;rdierne af y for x=0,
  x=1,x= 2, x=3 ... x=10. Ret det derefter til at skrive ud for
  x=0,x=10,x=20,x=30...x=100.</P>
  <LI><P LANG="da-DK" CLASS="western">Lav spillet &quot;G&aelig;t
  hvilket tal jeg t&aelig;nker p&aring;&quot;: Lav et program, der
  husker et tal fra 1 til 20, som brugeren skal g&aelig;tte. Her er et
  forslag til dialogen med brugeren: <BR><FONT FACE="Courier New"><FONT SIZE=1 STYLE="font-size: 8pt">G&aelig;t
  et tal: 8 <BR>Tallet jeg t&aelig;nker p&aring; er h&oslash;jere.
  <BR>G&aelig;t et tal: 13 <BR>Tallet jeg t&aelig;nker p&aring; er
  lavere. <BR>G&aelig;t et tal: 11 <BR>Det er det rigtige tal! Du
  brugte 3 fors&oslash;g.</FONT></FONT><BR>Vink: Et tilf&aelig;ldigt
  tal mellem 1 og 20 kan f&aring;s med (int) (Math.random()*20 + 1)</P>
</OL>
<H2 CLASS="western" STYLE="">2.6 <a name='afsn2.6'></a>V&aelig;rditypekonvertering</SPAN></H2>
<P LANG="da-DK" CLASS="western">I Java har alle variabler en bestemt
type gennem hele deres levetid. Det s&aelig;tter nogle begr&aelig;nsninger
for, hvilke v&aelig;rdier man kan tildele en variabel. N&aring;r man
f&oslash;rst har v&aelig;nnet sig til det, er det en stor hj&aelig;lp,
fordi overs&aelig;tteren p&aring; denne m&aring;de ofte fanger fejl i
programmerne (desuden g&oslash;r det, at computeren hurtigere kan
udf&oslash;re beregninger).</P>
<P LANG="da-DK" CLASS="western">I Java kan man f.eks. ikke l&aelig;gge
en double-v&aelig;rdi ind i en int-variabel:</P>
<PRE CLASS="kode-western">  int x;
  x = 2.7; <I>// Overs&aelig;tterfejl:</I> <I>Possible loss of precision: double, required: int</I>.</PRE><P LANG="da-DK" CLASS="western">
Fors&oslash;ger man, vil man f&aring; en overs&aelig;tter-fejl.
&Aring;rsagen til, at vi i Java ikke kan gemme 2.7 i <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">x</SPAN></SPAN></FONT></FONT>,
kan forst&aring;s p&aring; to m&aring;der, der begge er rigtige og
gyldige. 
</P>
<OL>
  <LI><P LANG="da-DK" CLASS="western"><FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">x</SPAN></SPAN></FONT></FONT>
  har kun plads i lageret til at gemme hele tal.</P>
  <LI><P LANG="da-DK" CLASS="western"><FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">x</SPAN></SPAN></FONT></FONT>
  er erkl&aelig;ret som en int og skal derfor blive ved med at v&aelig;re
  en int. I de efterf&oslash;lgende beregninger kan det have stor
  betydning, om <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">x</SPAN></SPAN></FONT></FONT>
  har en kommadel. Programm&oslash;ren skal derfor kunne se p&aring;,
  hvordan <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">x</SPAN></SPAN></FONT></FONT>
  er erkl&aelig;ret og derefter v&aelig;re helt sikker p&aring;,
  hvilke v&aelig;rdier <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">x</SPAN></SPAN></FONT></FONT>
  kan indeholde.</P>
</OL>
<P LANG="da-DK" CLASS="western">For at kunne gemme 2.7 i <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">x</SPAN></SPAN></FONT></FONT>
bliver man derfor n&oslash;dt til at lave 2.7 om til en int-v&aelig;rdi.
Det kaldes at typekonvertere v&aelig;rdien (eng.: cast). Dette er
ikke helt uden problemer:</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western">Der er &aring;benlyst et
  informationstab, da kommadelen af v&aelig;rdien m&aring; fjernes.</P>
  <LI><P LANG="da-DK" CLASS="western">Derudover kunne double-v&aelig;rdien
  v&aelig;re et meget stort tal (f.eks. 5 mia. i stedet for 2.7), som
  ikke kan rummes i en int (der kun kan rumme tal fra -2 mia. til +2
  mia). 
  </P>
  <LI><P LANG="da-DK" CLASS="western">Konverteringen kan foretages p&aring;
  flere m&aring;der. Skal man afrunde korrekt op til 3 eller nedrunde
  til 2?</P>
</UL>
<P LANG="da-DK" CLASS="western">Af disse &aring;rsager bliver man i
nogle tilf&aelig;lde n&oslash;dt til eksplicit at fort&aelig;lle
overs&aelig;tteren, at den skal foretage en konvertering af v&aelig;rdien
til en anden type.</P>
<H3 CLASS="western">2.6.1 <a name='afsn2.6.1'></a>Eksplicit typekonvertering</H3>
<P LANG="da-DK" CLASS="western">Man konverterer en v&aelig;rdi til en
anden type, ved at skrive det eksplicit med:</P>
<PRE CLASS="kode-western">  int x;
  x = (int) 2.7;</PRE><P LANG="da-DK" CLASS="western">
Inde i parentesen skriver man typen, som v&aelig;rdien lige til h&oslash;jre
skal konverteres til. 
</P>
<P LANG="da-DK" CLASS="western">Denne form for typekonvertering
runder altid ned<A CLASS="sdfootnoteanc" NAME="sdfootnote13anc" HREF="#sdfootnote13sym"><SUP>13</SUP></A>
til n&aelig;rmeste hele tal<A CLASS="sdfootnoteanc" NAME="sdfootnote14anc" HREF="#sdfootnote14sym"><SUP>14</SUP></A>.</P>
<H3 CLASS="western" STYLE="">2.6.2 <a name='afsn2.6.2'></a>Implicit
typekonvertering</H3>
<P LANG="da-DK" CLASS="western">Implicit (v&aelig;rdi-)typekonvertering
betyder, at overs&aelig;tteren selv laver konverteringen, uden at
programm&oslash;ren beh&oslash;ver at skrive noget s&aelig;rligt om,
at den skal g&oslash;re det.</P>
<PRE CLASS="kode-western">  double y;
  y = 4;   <I>// OK: Implicit v&aelig;rdi-typekonvertering.</I></PRE><P LANG="da-DK" CLASS="western">
Selvom 4 er en int-v&aelig;rdi, kan <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">y</SPAN></SPAN></FONT></FONT>
godt indeholde den, da den svarer til double-v&aelig;rdien 4.0. Denne
form for konvertering er s&aring;ledes ikke n&aelig;r s&aring;
problematisk, som i det tidligere eksempel.</P>
<P LANG="da-DK" CLASS="western">En tommelfingerregel i Java er, at
n&aring;r modtagertypen kan indeholde hele intervallet af mulige
v&aelig;rdier for afsendertypen, kan den v&aelig;re implicit. I
appendiks 2.11.2 sidst i dette kapitel findes en tabel over
typerne.</P>
<H3 CLASS="western">2.6.3 <a name='afsn2.6.3'></a>Misforst&aring;elser omkring
typekonvertering</H3>
<P LANG="da-DK" CLASS="western">Bem&aelig;rk, at det kun er <I>v&aelig;rdien</I>,
der bliver konverteret. Variablen bliver ikke &aelig;ndret.</P>
<PRE CLASS="kode-western">  int x;
  double y;
  y= 2.7;
  <B>x= (int) y</B>;              <I>// punkt A</I>
  System.out.println(x);
  System.out.println(y);   <I>// y er up&aring;virket af typekonverteringen</I></PRE>
<HR>
<PRE CLASS="kode-western">2
2.7</PRE><P LANG="da-DK" CLASS="western">
Man kunne m&aring;ske fristes til at tro, at i punkt A konverteres
variablen <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">y</SPAN></SPAN></FONT></FONT>
til en variabel af typen int, men det ville s&aring; betyde, at den
sidste linje i uddata skulle v&aelig;re 2. Men husk at:</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">En variabels type
er altid, som den er erkl&aelig;ret - den kan ikke &aelig;ndre type</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Det, der sker i ovenst&aring;ende,
er, at <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">y</SPAN></SPAN></FONT></FONT>'s
v&aelig;rdi (2.7) l&aelig;ses, en konverteret v&aelig;rdi (2)
beregnes og denne v&aelig;rdi l&aelig;gges ind i <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">x</SPAN></SPAN></FONT></FONT>.</P>
<P LANG="da-DK" CLASS="western">En anden misforst&aring;else er at
tro, at overs&aelig;tteren kan se, at noget er lovligt ud fra de
&oslash;vrige programlinjer, f.eks.:</P>
<PRE CLASS="kode-western">  int x;
  double y;
  y= 4.0;
  x= y;  <I>// Fejl - her stopper overs&aelig;tteren med &quot;Possible loss of precision&quot;</I></PRE><P LANG="da-DK" CLASS="western">
I ovenst&aring;ende tilf&aelig;lde kunne man tro, at man kan bruge
implicit typekonvertering, fordi overs&aelig;tteren kan se, at y
altid er 4.0 og at der derfor ikke g&aring;r information tabt. Men s&aring;
klog er overs&aelig;tteren ikke. N&aring;r den skal afg&oslash;re, om
den kan lave implicit typekonvertering, kigger den <I>kun</I> p&aring;
typerne af variabler og v&aelig;rdier. Den skeler ikke til resten af
programmet<A CLASS="sdfootnoteanc" NAME="sdfootnote15anc" HREF="#sdfootnote15sym"><SUP>15</SUP></A>.</P>
<H2 CLASS="western" STYLE="">2.7 <a name='afsn2.7'></a>Fejl</SPAN></H2>
<P LANG="da-DK" CLASS="western">Som sagt udf&oslash;rer computeren
programmet instruktion for instruktion som en kogebogsopskrift.
Computeren forst&aring;r ikke programmet, men udf&oslash;rer blot
det, programm&oslash;ren (kogebogsforfatteren) har skrevet.</P>
<H3 CLASS="western">2.7.1 <a name='afsn2.7.1'></a>Indholdsm&aelig;ssige (logiske) fejl</H3>
<P LANG="da-DK" CLASS="western">Da maskinen ikke forst&aring;r
programmet, kan den heller ikke rette op p&aring; fejlene i
programm&oslash;rens opskrift eller forst&aring;, hvad
programm&oslash;ren &quot;mener&quot; med det, han skrev. Man kan
alts&aring; sagtens komme til at lave et program, der g&oslash;r
noget andet end det, programm&oslash;ren har tilsigtet:</P>
<PRE CLASS="kode-western">public class ProgramMedFejl
{
  public static void main (String[] arg)
  {
    System.out.println(&quot;Hej Verdne!&quot;);
    int sum = 2 - 2;
    System.out.println(&quot;2 og 2 er &quot;+sum);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Hej Verdne!
2 og 2 er 0</PRE><P LANG="da-DK" CLASS="western">
Dette eksempel har en stavefejl og en forkert udregning. I <a href='kapitel2.jsp#afsn2.5.4'>afsnit 2.5.4</a>
om uendelige l&oslash;kker s&aring; vi en anden fejl, der gjorde, at
programmet aldrig stoppede. Et andet eksempel kunne v&aelig;re et
skatteprogram, der glemmer at tage h&oslash;jde for bundfradraget.</P>
<H3 CLASS="western">2.7.2 <a name='afsn2.7.2'></a>Sproglige fejl</H3>
<P LANG="da-DK" CLASS="western">Mens computeren ikke har mulighed
for, at finde indholdsm&aelig;ssige fejl i programmerne, kan den godt
finde sproglige og syntaksm&aelig;ssige problemer, dvs. hvis
kildekoden g&oslash;r brug af ukendte variabler eller metoder, eller
ikke er gyldig i forhold til sprogets syntaks (den formelle
definition af, hvordan man skriver javakode).</P>
<P LANG="da-DK" CLASS="western">Hvis der er sproglige fejl i
kildekoden, kan den ikke overs&aelig;ttes til bytekode, s&aring; man
kan alts&aring; overhovedet ikke komme til at pr&oslash;ve sit
program. De f&oslash;lgende instruktioner er alle forkerte og vil
blive fanget under overs&aelig;ttelsen af programmet. Ofte kan
fejlmeddelelsen overraske lidt, men med lidt &oslash;velse kan man
l&aelig;re at forst&aring; den &quot;firkantede&quot; m&aring;de, som
computeren &quot;t&aelig;nker&quot; p&aring;:</P>

<PRE CLASS="kode-western">    System.out.println(&quot;Hej verden!);</PRE><P LANG="da-DK" CLASS="western">
Her mangler en slut-&quot; til at markere, hvor strengen stopper.
Overs&aelig;tteren skriver <I>unclosed character literal</I>. Den kan
ikke regne ud, at strengen slutter lige f&oslash;r ')'.</P>

<PRE CLASS="kode-western">    System.out.pintln(&quot;Hej verden!&quot;);</PRE><P LANG="da-DK" CLASS="western">
Kaldet til println er stavet forkert. Overs&aelig;tteren skriver
<I>method pintln(java.lang.String) not found in class
java.io.PrintStream</I>. Den kan ikke finde ud af, at man mener
p<I>r</I>intln (med r) i stedet for pintln.</P>


<PRE CLASS="kode-western">    system.out.println(&quot;Hej verden!&quot;);</PRE><P LANG="da-DK" CLASS="western">
System er stavet forkert (med sm&aring;t). Overs&aelig;tteren skriver
<I>cannot access class system.out; neither class nor source found for
system.out</I>. Den skelner mellem store og sm&aring; bogstaver og
kan ikke se, at man mener System (med stort) i stedet for system.</P>

<PRE CLASS="kode-western">    System.out.println(Hej verden!);</PRE><P LANG="da-DK" CLASS="western">
Der mangler &quot; til at markere, hvor strengen starter og slutter.
Overs&aelig;tteren skriver <I>')' expected</I> og peger lige
efter Hej. Den forst&aring;r ikke at &quot;Hej verden!&quot; er en
tekststreng, n&aring;r &quot;-tegnene mangler og mener derfor, at
'Hej' og 'verden!' skal behandles adskilt.</P>

<P LANG="da-DK" CLASS="western">N&aring;r man skal finde en fejl,
g&aelig;lder det om at n&aelig;rl&aelig;se fejlmeddelelsen og
programkoden omkring stedet, hvor fejlen er og at huske, at
computeren f&oslash;lger faste regler, men ikke forst&aring;r, hvad
der foreg&aring;r. F.eks. er den sidste fejlmeddelelse <I>')'
expected</I> ikke s&aelig;rlig sigende, da fejlen formentlig er, at
der mangler &quot;-tegn.</P>
<P LANG="da-DK" CLASS="western">Det kan v&aelig;re banaliteter, der
er &aring;rsag til sprogfejl. Det giver ofte anledning til sprogfejl,
at folk glemmer, at der er forskel p&aring; store og sm&aring;
bogstaver.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Java skelner
altid mellem store og sm&aring; bogstaver</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Det er god stil
konsekvent at skrive klassenavne med stort og variabler og metoder
med sm&aring;t</BLOCKQUOTE>
<H3 CLASS="western">2.7.3 <a name='afsn2.7.3'></a>K&oslash;retidsfejl</H3>
<P LANG="da-DK" CLASS="western">Visse fejl opst&aring;r f&oslash;rst
ved udf&oslash;relsen af programmet. Selvom alting er syntaktisk
korrekt, opst&aring;r der alligevel en undtagelse fra den normale
programudf&oslash;relse. 
</P>
<P LANG="da-DK" CLASS="western">Herunder ses et program, der stopper
p&aring; grund af division med 0.</P>
<PRE CLASS="kode-western">public class ProgramMedFejl2
{
  public static void main (String[] arg)
  {
    int a,b,c;

    a = 5;
    b = 6;

    c = b/(a-5);
    System.out.println(&quot;c = &quot;+c);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Exception in thread &quot;main&quot; java.lang.ArithmeticException: / by zero
        at ProgramMedFejl2.main(ProgramMedFejl2.java:10)</PRE>
<P LANG="da-DK" CLASS="western">K&oslash;retidsfejl for&aring;rsager,
at der opst&aring;r en undtagelse (eng.: exception), som, hvis den
ikke h&aring;ndteres, stopper programudf&oslash;relsen (popul&aelig;rt:
programmet 'g&aring;r ned'). 
</P>
<P LANG="da-DK" CLASS="western">Dette vil blive behandlet grundigere
i <a href='kapitel14.jsp'>kapitel 14</a> om undtagelser.</P>

<H2 CLASS="western" STYLE="">2.8 <a name='afsn2.8'></a>Test dig
selv</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.8">
  <input type='checkbox' name='vis' value='2.8'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.8'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western" STYLE="">2.9 <a name='afsn2.9'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.9">
  <input type='checkbox' name='vis' value='2.9'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.9'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">2.9.1 <a name='afsn2.9.1'></a>Gode r&aring;d om programmering</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.9.1">
  <input type='checkbox' name='vis' value='2.9.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.9.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<H2 CLASS="western" STYLE="">2.10 <a name='afsn2.10'></a>Opgaver</SPAN></H2>
<P LANG="da-DK" CLASS="western">Overs&aelig;t og k&oslash;r et af
dine egne programmer fra kommandolinjen (se <a href='kapitel2.jsp#afsn2.1.3'>afsnit 2.1.3</a>).</P>
<H3 CLASS="western">2.10.1 <a name='afsn2.10.1'></a>Befordringsfradrag</H3>
<P LANG="da-DK" CLASS="western">Lav et program, som udregner
befordringsfradraget (det, der kan tr&aelig;kkes fra i skat ud fra,
hvor langt der er mellem arbejde og hjem).</P>
<OL>
  <LI><P LANG="da-DK" CLASS="western">Udregn og udskriv fradraget pr.
  dag fra 25 til 75 km p&aring; hver sin linje.</P>
  <LI><P LANG="da-DK" CLASS="western">Udregn og udskriv fradraget pr.
  dag fra 25 til 150 km p&aring; hver sin linje. 
  </P>
  <LI><P LANG="da-DK" CLASS="western">Udregn og udskriv fradraget pr.
  dag fra 10 til 150 km p&aring; hver sin linje. Kun hver 10. km
  udskrives (10km, 20km, 30km...). Reglerne for fradraget for &aring;r
  2000 var f&oslash;lgende:<BR>  f&oslash;rste 24 km  intet fradrag<BR>  25
   - 100 km    154 &oslash;re pr. km<BR>  over 100 km  77 &oslash;re pr.
  km</P>
</OL>
<H3 CLASS="western">2.10.2 <a name='afsn2.10.2'></a>Kurveprogram</H3>
<P LANG="da-DK" CLASS="western">Denne opgave benytter begreber, som
man l&aelig;rer i f.eks. den matematiske gren af gymnasiet. Kender du
ikke i forvejen disse begreber, b&oslash;r du springe opgaven over,
de er ikke n&oslash;dvendige for at l&aelig;re at programmere.</P>
<OL>
  <LI><P LANG="da-DK" CLASS="western">Skriv et program, der udskriver
  grafen over kvadratrod-funktionen (Math.sqrt()).<BR>Vink: N&aring;r
  du vil skrive en &quot;*&quot; uden linjeskift, kan du bruge
  System.out.print(&quot;*&quot;) (dvs. uden 'ln'). N&aring;r du vil
  skifte linje, kan du bruge System.out.println() uden parametre.</P>
  <LI><P LANG="da-DK" CLASS="western">Lav kurveprogrammet om, s&aring;
  det i stedet viser kurven over polynomiet 0.2*x*x&nbsp;+0.5*x&nbsp;+2.
  Lav programmet, s&aring; det er nemt at se, hvor man skal rette, for
  at &aelig;ndre funktionen, intervalstart, intervalslut, skalering og
  forskydning af y-aksen. Dvs. lav det til variabler og brug
  kommentarer, til at markere stederne i programmet.</P>
  <LI><P LANG="da-DK" CLASS="western">Lav om p&aring;
  kurvetegningsprogrammet, s&aring; kurven ikke er udfyldt, men tegnes
  som en streg. 
  </P>
  <LI><P LANG="da-DK" CLASS="western">Eventuelt: Udvid kurveprogrammet
  til at udregne det totale antal af stjerner, der skrives ud
  (udregn integralet af funktionen numerisk ved at summere arealet
  under grafen). Er det nemmest at g&oslash;re l&oslash;bende,
  mens stjernerne tegnes, eller bagefter? Hvordan ville du g&oslash;re
  p&aring; den ene og p&aring; den anden m&aring;de?</P>
</OL>

<H2 CLASS="western" STYLE="">2.11 <a name='afsn2.11'></a>Appendiks</SPAN></H2>
<P LANG="da-DK" CLASS="western">Dette afsnit s&aelig;tter det, du har
l&aelig;rt i kapitlet, i system og kan senere bruges som
opslagsv&aelig;rk. Enkelte steder st&aring;r der noget, som ikke
er gennemg&aring;et endnu, men som er med for helhedens skyld.</P>
<H3 CLASS="western">2.11.1 <a name='afsn2.11.1'></a>Navngivningsregler</H3>
<P LANG="da-DK" CLASS="western">Variabler og metoder b&oslash;r have
lille startbogstav. <BR>Eksempler: n, alder, tal,
talDerSkalUnders&oslash;ges, main(), println(), sqrt().</P>
<P LANG="da-DK" CLASS="western">Klasser b&oslash;r have stort
startbogstav.<BR>Eksempler: HejVerden, Cylinderberegning, Syvtabel2</P>
<P LANG="da-DK" CLASS="western">Best&aring;r navnet af flere ord,
stryger man normalt mellemrummene og lader hvert af de efterf&oslash;lgende
ord starte med stort (nogen bruger ogs&aring; understreg _ som
mellemrum).</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western">Navnet kan best&aring; af A-&Aring;,
  a-&aring;, 0-9, $ og _</P>
  <LI><P LANG="da-DK" CLASS="western">Det m&aring; ikke starte med et
  tal. Det kan have en vilk&aring;rlig l&aelig;ngde.</P>
  <LI><P LANG="da-DK" CLASS="western">Lovlige navne: peter, Peter,
  $antal, var2, J2EE, dette_er_en_test</P>
  <LI><P LANG="da-DK" CLASS="western">Ulovlige navne: 7eleven,
  dette-er-en-test, peter#</P>
</UL>
<P LANG="da-DK" CLASS="western">Da visse styresystemer endnu ikke
underst&oslash;tter &aelig;, &oslash; og &aring; i filnavne, b&oslash;r
man undg&aring; disse i klassenavne.</P>
<H3 CLASS="western">2.11.2 <a name='afsn2.11.2'></a>De simple typer</H3>
<P LANG="da-DK" CLASS="western">Her er en oversigt over alle de
simple variabeltyper i Java.</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0 STYLE="page-break-inside: avoid">
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">Type</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Art</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Antal bit</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Mulige v&aelig;rdier</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Standardv&aelig;rdi</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">byte</P>
      </TD>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">heltal</P>
      </TD>
      <TD VALIGN=BOTTOM SDVAL="8" SDNUM="1553;">
        <P LANG="da-DK" CLASS="western">8</P>
      </TD>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">-128 til 127</P>
      </TD>
      <TD VALIGN=BOTTOM SDVAL="0" SDNUM="1553;">
        <P LANG="da-DK" CLASS="western">0</P>
      </TD>
    </TR>
    <TR>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">short</P>
      </TD>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">heltal</P>
      </TD>
      <TD VALIGN=BOTTOM SDVAL="16" SDNUM="1553;">
        <P LANG="da-DK" CLASS="western">16</P>
      </TD>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">-32768 til 32767</P>
      </TD>
      <TD VALIGN=BOTTOM SDVAL="0" SDNUM="1553;">
        <P LANG="da-DK" CLASS="western">0</P>
      </TD>
    </TR>
    <TR>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">int 
        </P>
      </TD>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">heltal</P>
      </TD>
      <TD VALIGN=BOTTOM SDVAL="32" SDNUM="1553;">
        <P LANG="da-DK" CLASS="western">32</P>
      </TD>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">-2147483648 til 2147483647</P>
      </TD>
      <TD VALIGN=BOTTOM SDVAL="0" SDNUM="1553;">
        <P LANG="da-DK" CLASS="western">0</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">long</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">heltal</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">64</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">-9223372036854775808 til
        9223372036854775807</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">0</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">float</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">kommatal</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">32</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">&plusmn;1.40239846E-45 til
        &plusmn;3.40282347E+38</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">0.0</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">double</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">kommatal</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">64</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">&plusmn;4.94065645841246544E-324
        til</P>
        <P LANG="da-DK" CLASS="western">&plusmn;1.79769313486231570E+308 
        </P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">0.0</P>
      </TD>
    </TR>
    <TR>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">char</P>
      </TD>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">unicode</P>
      </TD>
      <TD VALIGN=BOTTOM SDVAL="16" SDNUM="1553;">
        <P LANG="da-DK" CLASS="western" ALIGN=LEFT>16</P>
      </TD>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">\u0000 til \uffff (0 til 65535)</P>
      </TD>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">\u0000</P>
      </TD>
    </TR>
    <TR>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">boolean</P>
      </TD>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">logisk</P>
      </TD>
      <TD VALIGN=BOTTOM SDVAL="1" SDNUM="1553;">
        <P LANG="da-DK" CLASS="western" ALIGN=LEFT>1</P>
      </TD>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">true og false</P>
      </TD>
      <TD VALIGN=TOP>
        <P LANG="da-DK" CLASS="western">false</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<P LANG="da-DK" CLASS="western">De vigtigste er int, double og
boolean. I enkelte tilf&aelig;lde bliver long og char ogs&aring;
brugt, mens byte, short og float meget sj&aelig;ldent bruges.</P>
<H3 CLASS="western">2.11.3 <a name='afsn2.11.3'></a>V&aelig;rditypekonvertering</H3>
<P LANG="da-DK" CLASS="western">Konvertering til en anden type sker
automatisk (implicit) i tilf&aelig;lde, hvor der ikke mistes
information (forst&aring;et p&aring; den m&aring;de, at
intervallet af de mulige v&aelig;rdier udvides), dvs. 
</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  fra byte til short, int, long, float eller double</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  fra short til int, long, float eller double</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  fra int til long, float eller double</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  fra long til float eller double</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  fra float til double.</P>
</UL>


<P LANG="da-DK" CLASS="western">Den anden vej, dvs. hvor der muligvis
mistes information, fordi intervallet af mulige v&aelig;rdier
indsn&aelig;vres, skal man skrive en eksplicit typekonvertering. 
</P>
<P LANG="da-DK" CLASS="western">Det g&oslash;res ved at skrive en
parentes med typenavnet foran det, der skal konverteres:</P>
<PRE CLASS="kode-western">int x;
double y;
y = 3.8;
x = (int) y</PRE><P LANG="da-DK" CLASS="western">
Her sk&aelig;res kommadelen af 3.8 v&aelig;k og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">x</SPAN></SPAN></FONT></FONT>
f&aring;r v&aelig;rdien 3. 
</P>
<P LANG="da-DK" CLASS="western">Eksplicit typekonvertering sikrer, at
programm&oslash;ren er bevidst om informationstabet (glemmes det,
kommer overs&aelig;tteren med fejlen: <I>possible loss of precision:
double, required: int</I>). 
</P>
<P LANG="da-DK" CLASS="western">Det skal ske</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  fra double til float, long, int, short, char eller byte</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  fra float til long, int, short, char eller byte</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  fra long til int, short, char eller byte</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  fra int til short, char eller byte</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  fra short til char eller byte</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  fra byte til char</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  fra char til short eller byte.</P>
</UL>
<P LANG="da-DK" CLASS="western">Der kan ikke typekonverteres til
eller fra boolean.</P>
<H3 CLASS="western">2.11.4 <a name='afsn2.11.4'></a>Aritmetiske operatorer</H3>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0 STYLE="page-break-inside: avoid">
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">Operator</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Brug</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Forklaring</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">+</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a + b 
        </P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a lagt sammen med b</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">-</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a - b</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">b trukket fra a</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">*</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a * b</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a gange b</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">/</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a / b</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a divideret med b</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">%</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a % b</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">rest fra heltalsdivision af a med
        b</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">-</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">-a</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">den negative v&aelig;rdi af a</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">++</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a++</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a = a+1; v&aelig;rdi f&oslash;r
        opt&aelig;lling</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">++</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">++a</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a = a+1; v&aelig;rdi efter
        opt&aelig;lling</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">--</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a--</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a = a-1; v&aelig;rdi f&oslash;r
        nedt&aelig;lling</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">--</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">--a</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a = a-1; v&aelig;rdi efter
        nedt&aelig;lling</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<P LANG="da-DK" CLASS="western">Operatorerne giver altid samme type
som operanderne, der indg&aring;r. Det skal man v&aelig;re specielt
opm&aelig;rksom p&aring; for / (divisions) vedkommende, hvor resten
mistes ved heltalsdivision (f.eks er 4/5 = 0). Resten kan findes
med % (f.eks er 4%5 = 4, mens 6%5 = 1). &Oslash;nskes division med
kommatal, skal mindst en af operanderne v&aelig;re et kommatal (f.eks
er 4.0/5 = 0.8). 
</P>
<P LANG="da-DK" CLASS="western">Operatoren ++ t&aelig;ller en
variabel op med &eacute;n : a++ svarer til a=a+1. Tilsvarende er a--
det samme som a=a-1.</P>

<H3 CLASS="western">2.11.5 <a name='afsn2.11.5'></a>Regning med logiske udtryk</H3>
<P LANG="da-DK" CLASS="western">u1 og u2 er to logiske udtryk eller
logiske variabler</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">Operator</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Brug</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Forklaring</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">&amp;&amp;</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">u1 &amp;&amp; u2</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">b&aring;de u1 og u2 er sandt</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">||  </P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">u1 || u2</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">u1 eller u2 er sandt</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">!</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">! u1</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">negation af u1</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>

<P LANG="da-DK" CLASS="western"><B>Operator &amp;&amp;</B> udtrykker,
at b&aring;de 1. <B>og</B> 2. udtryk skal v&aelig;re sandt:</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">1. udtryk</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">2. udtryk</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">1. udtryk &amp;&amp; 2. udtryk</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=BOTTOM>
      <TD SDVAL="0" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">FALSA</P>
      </TD>
      <TD SDVAL="0" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">FALSA</P>
      </TD>
      <TD SDVAL="0" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">FALSA</P>
      </TD>
    </TR>
    <TR VALIGN=BOTTOM>
      <TD SDVAL="0" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">FALSA</P>
      </TD>
      <TD SDVAL="1" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">VERA</P>
      </TD>
      <TD SDVAL="0" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">FALSA</P>
      </TD>
    </TR>
    <TR VALIGN=BOTTOM>
      <TD SDVAL="1" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">VERA</P>
      </TD>
      <TD SDVAL="0" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">FALSA</P>
      </TD>
      <TD SDVAL="0" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">FALSA</P>
      </TD>
    </TR>
    <TR VALIGN=BOTTOM>
      <TD SDVAL="1" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">VERA</P>
      </TD>
      <TD SDVAL="1" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">VERA</P>
      </TD>
      <TD SDVAL="1" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">VERA</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<P LANG="da-DK" CLASS="western">F.eks. er udsagnet (a &gt; 5 &amp;&amp;
a &lt; 10) sandt, hvis a er st&oslash;rre end 5 og a er mindre end
10.</P>

<P LANG="da-DK" CLASS="western"><B>Operator ||</B> udtrykker, at 1.
<B>eller</B> 2. udtryk skal v&aelig;re sandt.</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">1. udtryk</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">2. udtryk</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">1. udtryk || 2. udtryk</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=BOTTOM>
      <TD SDVAL="0" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">FALSA</P>
      </TD>
      <TD SDVAL="0" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">FALSA</P>
      </TD>
      <TD SDVAL="0" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">FALSA</P>
      </TD>
    </TR>
    <TR VALIGN=BOTTOM>
      <TD SDVAL="0" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">FALSA</P>
      </TD>
      <TD SDVAL="1" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">VERA</P>
      </TD>
      <TD SDVAL="1" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">VERA</P>
      </TD>
    </TR>
    <TR VALIGN=BOTTOM>
      <TD SDVAL="1" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">VERA</P>
      </TD>
      <TD SDVAL="0" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">FALSA</P>
      </TD>
      <TD SDVAL="1" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">VERA</P>
      </TD>
    </TR>
    <TR VALIGN=BOTTOM>
      <TD SDVAL="1" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">VERA</P>
      </TD>
      <TD SDVAL="1" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">VERA</P>
      </TD>
      <TD SDVAL="1" SDNUM="1553;0;BOOLEAN">
        <P LANG="da-DK" CLASS="western">VERA</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<P LANG="da-DK" CLASS="western">F.eks. er udsagnet (a &gt; 5 || a ==
0) sandt, hvis a er st&oslash;rre end 5, eller a er 0.</P>

<P LANG="da-DK" CLASS="western"><B>Operator !</B> Udtrykker, at
udtrykket skal <B>negeres</B>, dvs. at (!u1) er sandt, hvis u1 er
falsk og falsk, hvis u1 er sandt, f.eks. er udsagnet (!(a &gt; 5))
sandt, hvis der ikke g&aelig;lder, at a er st&oslash;rre end 5 (det
er det samme som (a &lt;= 5)).</P>
<P LANG="da-DK" CLASS="western">I visse andre programmeringssprog
skrives AND for &amp;&amp;, OR for || og NOT for !</P>

<H3 CLASS="western">2.11.6 <a name='afsn2.11.6'></a>Sammenligningsoperatorer</H3>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL>
  <COL>
  <COL>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">Operator</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Brug</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Forklaring</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">&gt;</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a &gt; b</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a st&oslash;rre end b</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">&gt;= 
        </P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a &gt;= b</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a st&oslash;rre end el. lig med b</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">&lt;</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a &lt; b</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a mindre end b</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">&lt;= 
        </P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a &lt;= b</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a mindre end el. lig med b</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western"> == 
        </P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a == b</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a er lig med (identisk med) b</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">!=</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a != b</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">a forskellig fra b</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>

<H2 CLASS="western" STYLE="">2.12 <a name='afsn2.12'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12">
  <input type='checkbox' name='vis' value='2.12'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">2.12.1 <a name='afsn2.12.1'></a>Grafiske indtastningsvinduer</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.1">
  <input type='checkbox' name='vis' value='2.12.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">2.12.2 <a name='afsn2.12.2'></a>Formatere tal og datoer</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.2">
  <input type='checkbox' name='vis' value='2.12.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western" STYLE="">2.12.3 <a name='afsn2.12.3'></a>Primtal</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.3">
  <input type='checkbox' name='vis' value='2.12.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
2.12.4 <a name='afsn2.12.4'></a>Klassemetoder</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.4">
  <input type='checkbox' name='vis' value='2.12.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
2.12.5 <a name='afsn2.12.5'></a>Kombination af logiske operatorer</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.5">
  <input type='checkbox' name='vis' value='2.12.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western" STYLE="">2.12.6 <a name='afsn2.12.6'></a>Alternativudtryk</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.6">
  <input type='checkbox' name='vis' value='2.12.6'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.6'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
2.12.7 <a name='afsn2.12.7'></a>Brug af ++ og -- (opt&aelig;lling og nedt&aelig;lling)</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.7">
  <input type='checkbox' name='vis' value='2.12.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">2.12.8 <a name='afsn2.12.8'></a>Brug af += og -=</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.8">
  <input type='checkbox' name='vis' value='2.12.8'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.8'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">2.12.9 <a name='afsn2.12.9'></a>do-while-l&oslash;kken</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.9">
  <input type='checkbox' name='vis' value='2.12.9'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.9'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
2.12.10 <a name='afsn2.12.10'></a>break</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.10">
  <input type='checkbox' name='vis' value='2.12.10'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.10'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
2.12.11 <a name='afsn2.12.11'></a>continue</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.11">
  <input type='checkbox' name='vis' value='2.12.11'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.11'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
2.12.12 <a name='afsn2.12.12'></a>break og continue med navngivne l&oslash;kker</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.12">
  <input type='checkbox' name='vis' value='2.12.12'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.12'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
2.12.13 <a name='afsn2.12.13'></a>switch</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.13">
  <input type='checkbox' name='vis' value='2.12.13'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.13'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">2.12.14 <a name='afsn2.12.14'></a>Komma i for-l&oslash;kker</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel2.jsp#afsn2.12.14">
  <input type='checkbox' name='vis' value='2.12.14'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.12.14'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<DIV ID="sdfootnote1">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>I
  Windows &aring;bner du en DOS-prompt ved at klikke i menuen Start,
  v&aelig;lge 'K&oslash;r...' og skrive 'cmd'.</P>
</DIV>
<DIV ID="sdfootnote2">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>Er
  HejVerden.java i mappen C:\javafiler s&aring; skriv '<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent"><FONT SIZE=1 STYLE="font-size: 8pt">cd
  C:\javafiler</FONT></SPAN></SPAN></FONT></FONT>' (og tryk
  retur-tasten).</P>
</DIV>
<DIV ID="sdfootnote3">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote3sym" HREF="#sdfootnote3anc">3</A>M&aring;ske
  skal du angive den fulde sti til javac, f.eks. <FONT FACE="Courier, monospace"><FONT SIZE=1 STYLE="font-size: 8pt">C:\jdk1.6\bin\javac
  HejVerden.java</FONT></FONT></P>
</DIV>
<DIV ID="sdfootnote4">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote4sym" HREF="#sdfootnote4anc">4</A>Kan
  klassen HejVerden ikke findes (NoClassDefFoundError) s&aring; pr&oslash;v:
  <FONT FACE="Courier, monospace"><FONT SIZE=1 STYLE="font-size: 8pt">java
  -cp . HejVerden</FONT></FONT></P>
</DIV>
<DIV ID="sdfootnote5">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote5sym" HREF="#sdfootnote5anc">5</A>N&oslash;jere
  bestemt til et tal mellem -2147483648 og 2147483647, da der kun er
  reserveret 4 byte, dvs. 32 bit. 
  </P>
</DIV>
<DIV ID="sdfootnote6">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote6sym" HREF="#sdfootnote6anc">6</A>Der
  er alts&aring; ikke tale om en matematisk ligning, der altid skal
  g&aelig;lde, men om en tildeling, hvor variablen p&aring; venstre
  side f&aring;r tildelt v&aelig;rdien af udtrykket p&aring;
  h&oslash;jresiden.</P>
</DIV>
<DIV ID="sdfootnote7">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote7sym" HREF="#sdfootnote7anc">7</A>Man
  kan med operatoren % finde resten af divisionen. 13 % 5 giver alts&aring;
  3, fordi 13 - 5*2 = 3. 
  </P>
</DIV>
<DIV ID="sdfootnote8">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote8sym" HREF="#sdfootnote8anc">8</A>Opkaldt
  efter den britiske matematiker George Boole, 1815-64.</P>
</DIV>
<DIV ID="sdfootnote9">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote9sym" HREF="#sdfootnote9anc">9</A>De,
  som kender Pascal, vil genkende { som BEGIN og } som END.</P>
</DIV>
<DIV ID="sdfootnote10">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote10sym" HREF="#sdfootnote10anc">10</A>30-50
  % af de problemer, nybegyndere har med at f&aring; deres programmer
  til at virke, skyldes d&aring;rlig indrykning, som g&oslash;r koden
  uoverskuelig.</P>
</DIV>
<DIV ID="sdfootnote11">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote11sym" HREF="#sdfootnote11anc">11</A>P&aring;
  et tidspunkt n&aring;r n til -2147483648. Variablens 32-bit
  kapacitet vil v&aelig;re opbrugt og n vil faktisk skifte til
  2147483647, som er st&oslash;rre end 10, hvorved l&oslash;kken vil
  stoppe, men der er n&aelig;ppe nogen, der gider vente s&aring;
  l&aelig;nge!</P>
</DIV>
<DIV ID="sdfootnote12">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote12sym" HREF="#sdfootnote12anc">12</A>hvilket
  er noget ganske andet end uendelig l<I><SPAN STYLE="font-weight: medium">y</SPAN></I>kke!</P>
</DIV>
<DIV ID="sdfootnote13">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote13sym" HREF="#sdfootnote13anc">13</A>Med
  metoden Math.round(x) kan man f&aring; den normale afrunding, hvor
  3.5 rundes op til 4 og 3.4999 rundes ned til 3.</P>
</DIV>
<DIV ID="sdfootnote14">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote14sym" HREF="#sdfootnote14anc">14</A>Man
  skal v&aelig;re opm&aelig;rksom p&aring;, at hvis det konverteres
  fra et meget stort tal, kan det v&aelig;re, at den nye type ikke kan
  repr&aelig;sentere tallet. F.eks. vil konvertering fra
  10000000000000.0 til int ikke give det forventede, da det
  st&oslash;rste tal, int kan rumme, er 2147483647. <BR>Ved
  typekonverteringen fra int til float mistes ogs&aring; noget
  pr&aelig;cision (de mindst betydende cifre).</P>
</DIV>
<DIV ID="sdfootnote15">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote15sym" HREF="#sdfootnote15anc">15</A>
  Den ser ikke engang, om en konstant v&aelig;rdi uproblematisk kan
  konverteres: int x; x=4.0; //Fejl</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel1.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel3.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (79% af vrket).
</font>
<br>
nsker du at se de sidste 21% af dette vrk (226970 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
